% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/founderLine.R
\name{founderLine}
\alias{founderLine}
\title{Identifies the matriline or patriline to which each individual in a pedigree
belongs}
\usage{
founderLine(pedigree, sex)
}
\arguments{
\item{pedigree}{A pedigree where the columns are ordered ID, Dam, Sire, Sex}

\item{sex}{Character indicating the column name in pedigree identifying
either the dam (for matriline) or sire (for patriline) identities}
}
\value{
A vector of length equal to the number of rows in the pedigree
}
\description{
For every individual in a pedigree, the function identifies either the one
female or male ancestor that is a founder (defined here as an individual
identity in the pedigree for which both dam and sire information are
missing).
}
\details{
Missing parents (e.g., base population) should be denoted by either 'NA',
'0', or '*'.

Individuals with a missing parent for the column identified by the 'sex'
argument are assigned themselves as their founder line. Thus, the definition
of the founder population from a given pedigree is simply all individuals
with missing parents (and in this case just a single missing parent
classifies an individual as a founder).
}
\examples{

 founderLine(FG90, sex = "dam")  # matriline from this example pedigree

 #Create random pedigree, tracking the matrilines
 ## Then compare with founderLine() output
 K <- 8  # No. individuals per generation (KEEP and even number)
 gen <- 10 # No. of generations
 datArr <- array(NA, dim = c(K, 5, gen))
 dimnames(datArr) <- list(NULL, 
c("id", "dam", "sire", "sex", "matriline"), NULL)
 # initialize the data array
 datArr[, "id", ] <- seq(K*gen)
 datArr[, "sex", ] <- c(1, 2)
 femRow <- which(datArr[, "sex", 1] == 2) # assume this is same each generation
 # (Why K should always be an even number)
 datArr[femRow, "matriline", 1] <- femRow
 # males have overlapping generations, BUT females DO NOT
 for(g in 2:gen){
   datArr[, "sire", g] <- sample(c(datArr[femRow-1, "id", 1:(g-1)]),
size = K, replace = TRUE)
   gdams <- sample(femRow, size = K, replace = TRUE)
   datArr[, c("dam", "matriline"), g] <- datArr[gdams, c("id", "matriline"), g-1]
 }
 ped <- data.frame(apply(datArr, MARGIN = 2, FUN = function(x){x}))
 nrow(ped)
 #Now run founderLine() and compare
 ped$line <- founderLine(ped, sex = "dam")
 stopifnot(identical(ped$matriline, ped$line),
	sum(ped$matriline-ped$line, na.rm = TRUE) == 0,
	range(ped$matriline-ped$line, na.rm = TRUE) == 0)


}
\author{
\email{matthewwolak@gmail.com}
}
