% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aic.R
\name{aic}
\alias{aic}
\title{Akaike Information Criterion}
\usage{
aic(logLik, fp, n = NULL)
}
\arguments{
\item{logLik}{A vector of model log-Likelihoods}

\item{fp}{A vector containing the numbers of free parameters of each model
included in the logLik vector}

\item{n}{An optional vector of sample sizes for each model.  Used to
calculate AICc (small sample un-biased AIC).}
}
\value{
a \code{list}:
  \describe{
    \item{AIC }{vector containing AIC/AICc (depending on value of \code{n})}
    \item{delta_AIC }{vector containing AIC differences from the minimum 
      AIC(c)}
    \item{AIClik }{vector containing likelihoods for each model, given the 
      data.  Represents the relative strength of evidence for each model.}
    \item{w }{Akaike weights.}
  }
}
\description{
Calculates AIC/AICc values, AIC differences, Likelihood of models, and model
probabilities.
}
\details{
Calculations and notation follows chapter 2 of Burnham and Anderson (2002).
}
\examples{

   aic(c(-3139.076, -3136.784, -3140.879, -3152.432), c(8, 7, 8, 5)) 

}
\references{
Burnham, K.P. and D.R. Anderson. 2002. Model Selection and
  Multimodel Inference. A Practical Information-Theoretic Approach, 2nd edn.
  Springer, New York.
}
\author{
\email{matthewwolak@gmail.com}
}
