% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naaccr_record.R
\name{naaccr_record}
\alias{naaccr_record}
\title{Analysis-ready NAACCR records}
\usage{
naaccr_record(..., keep_unknown = FALSE, version = NULL,
  format = NULL)
}
\arguments{
\item{...}{Arguments of the form \code{tag = value}, where \code{tag} is a
valid NAACCR data item name and \code{value} is the vector of the item's
values from the NAACCR format.}

\item{keep_unknown}{Logical indicating whether values of "unknown" should be
a level in the factor or \code{NA}.}

\item{version}{An integer specifying the NAACCR format version for parsing
the records. Use this or \code{format}, not both. If both \code{version}
and \code{format} are \code{NULL} (default), the most recent NAACCR format
will be used.}

\item{format}{A \code{\link{record_format}} object for parsing the records.}
}
\value{
A \code{data.frame} with columns named using the NAACCR XML scheme.
}
\description{
Subclass of \code{data.frame} for doing analysis with NAACCR records.
}
\details{
\code{naaccr_record} creates a \code{data.frame} of cancer incidence records
ready for analysis:
columns are of appropriate classes, coded values are replaced with factors,
and unknowns are replaced with \code{NA}.
}
