% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.sample.R
\name{na.bootstrap}
\alias{na.bootstrap}
\alias{na.resample}
\title{na.bootstrap}
\usage{
na.bootstrap(.x, ...)

na.resample(.x, ...)
}
\arguments{
\item{.x}{vector with}

\item{...}{additional arguments passed to \code{\link[base:sample]{base::sample()}}}
}
\description{
Replace missing values with value randomly drawn from x
}
\details{
\code{na.random} replaces missing values by sampling the non-missing values. By
default aampling occurs \strong{with replacement} since more valuables may be needed than
are available. This function is based on \code{\link[base:sample]{base::sample()}}.

The default is to replace bv sampling a population defined by the
non-missing values of \code{.x} \strong{with replacement}

\code{na.random} is an alias for \code{na.bootstrap}.
`
}
\note{
\code{na.bootstrap} is \strong{non-deterministic}. Use
\code{\link[base:set.seed]{base::set.seed()}} to make it deterministic
}
\examples{
  x <- c(1,NA,3)
  na.bootstrap(x)
  
}
\seealso{
\itemize{
\item \code{\link[base:sample]{base::sample()}}
}
}
