/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.TimeLimit;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;

public interface Solver {
    public List<Unit> solve(Graph var1, Signals var2) throws SolverException;

    public boolean isSolvedToOptimality();

    public TimeLimit getTimeLimit();

    public void setTimeLimit(TimeLimit var1);

    public void setLogLevel(int var1);

    public void setLB(double var1);

    public double getLB();

    public static Map<Edge, Double> makeHeuristicWeights(Graph graph, Signals signals) {
        HashMap<Edge, Double> weights = new HashMap<Edge, Double>();
        for (Edge e : graph.edgeSet()) {
            Node u = graph.getEdgeSource(e);
            Node v = graph.getEdgeTarget(e);
            Unit[] unitArray = new Unit[]{e, u, v};
            double weightSum = signals.sum(unitArray);
            if (weightSum > 0.0) {
                weights.put(e, 1.0 / weightSum);
                continue;
            }
            weights.put(e, 2.0);
        }
        return weights;
    }
}

