% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_branch.R
\name{add_formula_branch}
\alias{add_formula_branch}
\alias{add_formula_branch.mverse}
\title{Add formula branches to a \code{mverse} object.}
\usage{
add_formula_branch(.mverse, ...)

\method{add_formula_branch}{mverse}(.mverse, ...)
}
\arguments{
\item{.mverse}{a \code{mverse} object.}

\item{...}{\code{formula_branch} objects.}
}
\value{
The resulting \code{mverse} object.
}
\description{
This method adds one or more formula branches to
an existing \code{mverse} object. Formula branches
are used to specify model structure options for the analysis.
}
\examples{
# Define a formula branch.
model_specifications <- formula_branch(
  y ~ femininity,
  y ~ femininity + hurricane_strength,
  y ~ femininity * hurricane_strength
)
# Create a mverse, add the branch.
mv <- create_multiverse(hurricane) \%>\%
  add_formula_branch(model_specifications)
}
\seealso{
Other formula branch functions: 
\code{\link{formula_branch}()}
}
\concept{formula branch functions}
