% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_density_port.R
\name{quantile.density}
\alias{quantile.density}
\title{Extract Quantiles from 'density' Objects}
\usage{
\method{quantile}{density}(x, probs = seq(0.25, 0.75, 0.25), names = TRUE, normalize = TRUE, ...)
}
\arguments{
\item{x}{a object of class \code{density} or a list of densities}

\item{probs}{numeric vector of probabilities with values in [0,1]. Note that
elements very close to the boundaries return \code{Inf} or \code{-Inf}}

\item{names}{logical; if \code{TRUE}, the result has a names attribute, resp.
a rownames and colnames attributes. Set to \code{FALSE} for speedup with
many probabilities}

\item{normalize}{logical; if \code{TRUE} then the values in \code{x$y} are
multiplied with a factor such that their integral is equal to one.}

\item{...}{further arguments passed to or from other methods (currently
unused)}
}
\value{
If x is of class \code{density} (or a list with exactly one element),
  a vector with quantiles. If x is a list of densities, then the output is a
  matrix of quantiles, with each matrix row corresponding to the respective
  density.
}
\description{
Quantiles for objects of class \code{density}
}
\details{
This function is a near-exact copy of the \code{quantile.density}
  function from package BMS (\url{https://CRAN.R-project.org/package=BMS}).
  In spring of 2022, CRAN informed us that the BMS has been orphaned, so we
  copied the code (and corresponding documentation) we needed from it. See
  \doi{10.18637/jss.v068.i04} for their paper.

  The function \code{quantile.density()} applies generically to the built-in
  class \code{density} (as least for versions where there is no such method
  in the pre-configured packages). Note that this function relies on
  trapezoidal integration in order to compute the cumulative densities
  necessary for the calculation of quantiles.
}
\examples{
  rNorm_dens <- density(rnorm(100000))
  quantile(rNorm_dens)

}
\author{
Stefan Zeugner, \email{stefan.zeugner@ec.europa.eu}

Martin Feldkircher, \email{martin.feldkircher@da-vienna.ac.at}
}
