% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataStateSwitch.R
\name{dataStateSwitch}
\alias{dataStateSwitch}
\title{Alternate Observations in a Data Frame over States}
\usage{
dataStateSwitch(
  df,
  angles2 = list(yaw = 0, pitch = 90, roll = 30),
  scales2 = c(1, 0.5, 2),
  angles3 = list(yaw = 90, pitch = 0, roll = -30),
  scales3 = c(0.25, 0.1, 0.75)
)
}
\arguments{
\item{df}{A data frame returned by processNOCdata() or faultSwitch().}

\item{angles2}{Change the principal angles for State 2.}

\item{scales2}{Change the principal scales for State 2.}

\item{angles3}{Change the principal angles for State 3.}

\item{scales3}{Change the principal scales for State 3.}
}
\value{
A data frame containing the time index, state, and feature values
  after state-specific rotation and scaling; this data frame also contains
  the other columns of df that aren't the feature values. This data frame has
  \itemize{
    \item{dateTime - }{a POSIX column of the time stamps for each
      observation}
    \item{state - }{column of state membership (1, 2, or 3)}
    \item{x - }{the process values for the first feature, corresponding to
      t + random error}
    \item{y - }{the process values for the second feature, corresponding to
      t ^ 2 - 3 * t + random error}
    \item{z - }{the process values for the third feature, corresponding to
      -t ^ 3 + 3 * t ^ 2 + random error}
    \item{t - }{the non-stationary and autocorrelated latent feature}
    \item{err1 - }{a Gaussian white noise vector}
    \item{err2 - }{a Gaussian white noise vector}
    \item{err3 - }{a Gaussian white noise vector}
  }
}
\description{
Split single-state process observations, apply multiple state
  projections, and combine these observations into a single data frame,
  arranged by process time or index.
}
\details{
This function splits a process data frame by state, and rotates and
  scales the observations from states 2 and 3 by the scales and angles
  specified in the function arguments. After state-specific rotation and
  scaling, this function combines the observations back together and orders
  them by process time index. This function takes in data frame returned by
  processNOCdata() or faultSwitch(). This function calls rotateScale3D() and
  is called internally by mspProcessData().
}
\examples{
nrml <- processNOCdata()
dataStateSwitch(nrml)
}
\seealso{
Calls: \code{\link{processNOCdata}}, \code{\link{faultSwitch}},
  \code{\link{rotateScale3D}}. Called by: \code{\link{mspProcessData}}
}
