/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.HTMLPaneWithButtons;
import org.af.commons.widgets.buttons.OkCancelButtonPane;
import org.af.jhlir.call.RLegalName;
import org.af.jhlir.call.RList;
import org.af.jhlir.call.RNamedArgument;
import org.af.jhlir.call.RObj;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.Method;
import org.mutoss.MuTossControl;
import org.mutoss.Parameter;
import org.mutoss.gui.OutputPanel;
import org.mutoss.gui.parameterwidgets.BooleanWidget;
import org.mutoss.gui.parameterwidgets.CharacterChoiceWidget;
import org.mutoss.gui.parameterwidgets.IntegerWidget;
import org.mutoss.gui.parameterwidgets.NumberWidget;
import org.mutoss.gui.parameterwidgets.ParameterWidget;
import org.mutoss.gui.parameterwidgets.RObjectWidget;
import org.mutoss.gui.parameterwidgets.VarSelectWidget;

public class MethodDialog
extends JDialog
implements ActionListener {
    private static final Log logger = LogFactory.getLog(MethodDialog.class);
    Method method;
    HTMLPaneWithButtons infopane;
    Hashtable<String, ParameterWidget> ht = new Hashtable();
    Hashtable<String, JCheckBox> htC = new Hashtable();
    String selected = null;

    public MethodDialog(JFrame parent, Method method) {
        super((Frame)parent, "Method: " + method.getLabel());
        this.method = method;
        this.createContent();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.5;
        c.weighty = 1.0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getArgumentPanel(), c);
        ++c.gridx;
        c.weightx = 1.0;
        JScrollPane scrollPane = new JScrollPane((Component)this.infopane);
        this.getContentPane().add((Component)scrollPane, c);
        ++c.gridy;
        c.gridx = 0;
        OkCancelButtonPane buttonPane = new OkCancelButtonPane();
        buttonPane.addActionListener((ActionListener)this);
        c.gridwidth = 2;
        c.weighty = 0.0;
        this.getContentPane().add((Component)buttonPane, c);
        this.setSize(700, 500);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
        JViewport jv = scrollPane.getViewport();
        jv.setViewPosition(new Point(0, 0));
        this.infopane.setCaretPosition(0);
    }

    private void createContent() {
        this.infopane = new HTMLPaneWithButtons();
        try {
            this.infopane.appendHTML(this.method.getInfo());
        }
        catch (Exception e) {
            this.infopane.setText("An error occured and no info is available...");
            ErrorHandler.getInstance().makeErrDialog("An error occured and no info is available...", (Object)e, false);
        }
    }

    private JPanel getArgumentPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 19;
        panel.setLayout(new GridBagLayout());
        if (this.method.getErrorControl() != null) {
            panel.add((Component)new JLabel("Error Control: " + this.method.getErrorControl()), c);
            ++c.gridy;
        }
        for (Parameter p : this.method.getParameters()) {
            if (!p.isAdditional()) continue;
            if (p.isOptional()) {
                JCheckBox jch = new JCheckBox("Enable this parameter:", false);
                panel.add((Component)jch, c);
                c.gridwidth = 2;
                this.htC.put(p.getName(), jch);
                c.gridwidth = 1;
                ++c.gridy;
            }
            ParameterWidget widget = null;
            if (p.getType().equals("numeric")) {
                panel.add((Component)new JLabel(p.getLabel()), c);
                ++c.gridx;
                widget = new NumberWidget(p.getName());
                panel.add((Component)((Object)widget), c);
                this.ht.put(p.getName(), widget);
                if (p.getDefaultValue() != null) {
                    widget.setText("" + p.getDefaultValue().asRNumeric().getData()[0]);
                }
                c.gridx = 0;
                ++c.gridy;
            } else if (p.getType().equals("integer")) {
                panel.add((Component)new JLabel(p.getLabel()), c);
                ++c.gridx;
                widget = new IntegerWidget(p.getName());
                panel.add((Component)((Object)widget), c);
                if (p.getDefaultValue() != null) {
                    ((IntegerWidget)widget).setText("" + p.getDefaultValue().asRInteger().getData()[0]);
                }
            } else if (p.getType().equals("character")) {
                panel.add((Component)new JLabel(p.getLabel()), c);
                ++c.gridx;
                if (p.getChoices() != null) {
                    widget = new CharacterChoiceWidget(p.getName(), p.getChoices());
                } else if (p.getFromR() != null) {
                    ArrayList<RLegalName> v = new ArrayList<RLegalName>();
                    v.addAll(MuTossControl.getObj().getData().asRDataFrame().getFactorVars());
                    widget = new VarSelectWidget(p.getName(), v);
                }
                panel.add((Component)((Object)widget), c);
                if (p.getDefaultValue() != null) {
                    // empty if block
                }
            } else if (p.getType().equals("logical")) {
                panel.add((Component)new JLabel(p.getLabel()), c);
                ++c.gridx;
                widget = new BooleanWidget(p.getName());
                panel.add((Component)((Object)widget), c);
                if (p.getDefaultValue() != null) {
                    ((BooleanWidget)widget).setSelected(p.getDefaultValue().asRLogical().getData()[0]);
                }
            } else if (p.getType().equals("RObject")) {
                panel.add((Component)new JLabel(p.getLabel()), c);
                ++c.gridx;
                widget = new RObjectWidget(p.getName());
                panel.add((Component)((Object)widget), c);
            }
            c.gridx = 0;
            ++c.gridy;
            this.ht.put(p.getName(), widget);
        }
        return panel;
    }

    public String getSelected() {
        return this.selected;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            RList argsList = MuTossControl.getR().eval("as.list(formals(" + this.method.getFunction() + "))").asRList();
            RObj names = MuTossControl.getR().eval("names(formals(" + this.method.getFunction() + "))");
            String[] args = names != null ? MuTossControl.getR().eval("names(formals(" + this.method.getFunction() + "))").asRChar().getData() : new String[]{};
            Vector<Object> rargs = new Vector<Object>();
            Vector unknownArgs = new Vector();
            for (String arg : args) {
                if (arg.equals("pValues") && MuTossControl.getObj().hasPValues()) {
                    rargs.add(new RNamedArgument("pValues", MuTossControl.getObj().getPValues()));
                    continue;
                }
                if (arg.equals("alpha") && MuTossControl.getObj().hasErrorRate()) {
                    rargs.add(new RNamedArgument("alpha", MuTossControl.getObj().getAlpha()));
                    continue;
                }
                if (arg.equals("data") && MuTossControl.getObj().hasData()) {
                    rargs.add(new RNamedArgument("data", MuTossControl.getObj().getData()));
                    continue;
                }
                if (arg.equals("model") && MuTossControl.getObj().hasModel()) {
                    rargs.add(new RNamedArgument("model", MuTossControl.getObj().getRModel()));
                    continue;
                }
                if (arg.equals("hypotheses") && MuTossControl.getObj().hasModel()) {
                    rargs.add(new RNamedArgument("hypotheses", MuTossControl.getObj().getHypotheses()));
                    continue;
                }
                if (arg.equals("adjPValues") && MuTossControl.getObj().hasAdjPValues()) {
                    rargs.add(new RNamedArgument("adjPValues", MuTossControl.getObj().getAdjPValues()));
                    continue;
                }
                if (this.ht.get(arg) != null && (this.htC.get(arg) == null || this.htC.get(arg).isSelected())) {
                    rargs.add(this.ht.get(arg).getParameter());
                    continue;
                }
                logger.warn((Object)("Oh no! Argument " + arg + " can not be found!"));
            }
            MuTossControl.getR().eval("mutossGUI:::startRecording()");
            RList output = MuTossControl.getR().call(this.method.getFunction(), rargs.toArray()).asRList();
            MuTossControl.getR().eval("mutossGUI:::stopRecording()");
            OutputPanel.getOutputPanel().getOutputPane().appendHeadline(this.method.getLabel());
            String[] rOutput = MuTossControl.getR().eval("mutossGUI:::getOutput()").asRChar().getData();
            String outputString = "<p align=\"left\"><pre>";
            for (String ro : rOutput) {
                outputString = outputString + ro + "\n";
            }
            outputString = outputString + "</pre></p>";
            OutputPanel.addOutput(outputString);
            String[] rError = MuTossControl.getR().eval("mutossGUI:::getErrorMsg()").asRChar().getData();
            String errorString = "<p align=\"left\"><font color=#FF0000>";
            for (String ro : rError) {
                errorString = errorString + ro + "\n";
            }
            errorString = errorString + "</font></p>";
            OutputPanel.addOutput(errorString);
            for (String name : output.getNames()) {
                if (name.equals("adjPValues")) {
                    logger.info((Object)("Method " + this.method.getLabel() + " is setting the adjusted p-values."));
                    MuTossControl.getObj().setAdjPValues(output.get("adjPValues"), this.method.getLabel());
                    continue;
                }
                if (name.equals("rejected")) {
                    logger.info((Object)("Method " + this.method.getLabel() + " is setting the rejected hypotheses."));
                    MuTossControl.getObj().setRejected(output.get("rejected"), this.method.getLabel());
                    continue;
                }
                if (name.equals("confIntervals")) {
                    logger.info((Object)("Method " + this.method.getLabel() + " is setting the confidence intervals."));
                    MuTossControl.getObj().setConfIntervals(output.get("confIntervals"), this.method.getLabel());
                    continue;
                }
                if (name.equals("pValues")) {
                    logger.info((Object)("Method " + this.method.getLabel() + " is setting the unadjusted p-values."));
                    MuTossControl.getObj().setPValues(output.get("pValues"), this.method.getLabel());
                    continue;
                }
                if (name.equals("model")) {
                    logger.info((Object)("Method " + this.method.getLabel() + " is setting the model."));
                    MuTossControl.getObj().setModel(output.get("model"), this.method.getLabel());
                    continue;
                }
                if (name.equals("pi0")) {
                    logger.info((Object)("Method " + this.method.getLabel() + " is setting the pi0."));
                    MuTossControl.getObj().setP0(output.get("pi0"), this.method.getLabel());
                    continue;
                }
                if (!name.equals("errorControl")) continue;
                logger.info((Object)("Method " + this.method.getLabel() + " is setting the errorControl."));
                MuTossControl.getObj().setErrorControl(output.get("errorControl"), this.method.getLabel());
            }
            this.dispose();
        } else if (e.getActionCommand().equals("CANCEL")) {
            this.dispose();
        }
    }
}

