% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{prelimProcessAssess}
\alias{prelimProcessAssess}
\title{Run a Preliminary Process Assess analysis.}
\usage{
prelimProcessAssess(input, maxProcess = 6, approach = "counts",
  plot = TRUE, verbose = TRUE)
}
\arguments{
\item{input}{a mutationCounts-class object}

\item{maxProcess}{integer, maximum k to test}

\item{approach}{sting, "counts" or "freq"}

\item{plot}{logical, shall a plot be printed to the active device}

\item{verbose}{logical, info about the ongoing analysis be messaged/printed to console}
}
\value{
a data.frame showing the estimated total error with respect to the range of k values
}
\description{
This function is an attempt to analyze the relationship between error and k. In other words, 
the goal of prelimProcessAssess is to visualize the reduction in the error/residuals
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
