% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{decipherMutationalProcesses}
\alias{decipherMutationalProcesses}
\title{Decipher Mutational Processes Contributing to a Collection of Genomic Mutations.}
\usage{
decipherMutationalProcesses(input, params)
}
\arguments{
\item{input}{a mutationCounts-class object, including a mutation counts data.}

\item{params}{a mutFrameworkParams-class object including all the parameters required for 
running the mutational signature analysis.}
}
\value{
list including all results of the analysis.
The extracted signatures (processes) are included in the "processes" element of the list.
The relative contribution of each signature in each sample is summarized in the 
"exposures" element.
}
\description{
Decipher Mutational ProCancer cells accumulate DNA mutations as result of DNA 
damage and DNA repair processes. Thiscomputational framework allows to decipher 
mutational processes from cancer-derived somatic mutational catalogs.
}
\details{
This is one of the core functions included in the original mutSignatures R library, 
and in the WTSI MATLAB framework. This is the main user interface for the mutSignatures analysis.
}
\examples{
library(mutSignatures)
x <- mutSignatures:::getTestRunArgs("decipherMutationalProcesses")
x$muts
y <- mutSignatures::decipherMutationalProcesses(input = x$muts, 
                                                params = x$params)
y$Results$signatures

}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item WTSI framework: \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3588146/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
