% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetEMG.R
\name{subsetEMG}
\alias{subsetEMG}
\title{Subset raw EMG}
\usage{
subsetEMG(x, cy_max, cy_start = 1)
}
\arguments{
\item{x}{Objects of class \code{EMG} with elements \code{cycles} and \code{emg}}

\item{cy_max}{Maximum number of cycles to be considered}

\item{cy_start}{From which cycle should the subset begin?}
}
\value{
Object of class \code{EMG} with elements:\cr
\itemize{
\item \code{cycles} data frame containing cycle timings, with as many columns as many cycle subdivisions are wanted\cr
\item \code{emg} data frame containing raw EMG data in columns, first column is time
}
}
\description{
Subset raw EMG
}
\details{
Lists in the correct format can be created with the function \code{rawdata()}.
The first column of each \code{emg} element must be time in the same units as those
used for \code{cycles} (e.g., [s] or [ms]). For locomotion, thirty cycles
are enough for proper synergy extraction (Oliveira et al. 2014).
}
\examples{
# Load some data
data("RAW_DATA")
# Subset example raw data to the first 3 cycles
RAW_DATA_sub <- pbapply::pblapply(
  RAW_DATA,
  function(x) {
    subsetEMG(x,
      cy_max = 3,
      cy_start = 1
    )
  }
)
}
\references{
Oliveira, A. S. C., Gizzi, L., Farina, D. & Kersting, U. G.
Motor modules of human locomotion:
influence of EMG averaging, concatenation, and number of step cycles.
Front. Hum. Neurosci. 8, 335 (2014).
}
