% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_NMF.R
\name{classify_NMF}
\alias{classify_NMF}
\title{Muscle synergy classification with NMF}
\usage{
classify_NMF(x, interactive = TRUE)
}
\arguments{
\item{x}{A list of \code{musclesyneRgies} objects}

\item{interactive}{Logical, ask for interactive re-ordering or go fully automated?}
}
\value{
List of \code{musclesyneRgies} objects, each with elements:\cr
\itemize{
\item \code{syns} factorisation rank or minimum number of synergies\cr
\item \code{M} motor modules (time-invariant coefficients)\cr
\item \code{P} motor primitives (time-dependent coefficients)\cr
\item \code{V} original data\cr
\item \code{Vr} reconstructed data\cr
\item \code{iterations} number of iterations to convergence\cr
\item \code{R2} quality of reconstruction (coefficient of determination)
\item \code{rank_type} was the rank \code{fixed} or \code{variable}?\cr
\item \code{classification} classification type (\code{NMF})
}
}
\description{
Muscle synergy classification with NMF
}
\details{
This function must be applied to a list with a sufficient amount of trials, otherwise the
classification will not work. Typically, at least 10 trials for the same condition are needed
for satisfactory classification.
}
\examples{
# Load some data
data(SYNS)
# Classify synergies
SYNS_classified <- classify_NMF(SYNS,
  interactive = FALSE
)
}
