% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\docType{data}
\name{anscombe.extended}
\alias{anscombe.extended}
\title{Extended Anscombe's Quartett}
\format{
\code{list} with elements:
\itemize{
\item\code{anscombe.extended$N11}
 matrix with 11 samples for 5 examples the first 4 are the
        classical Anscombe Quartett, the fifth is a monoton relation
        which also features the same correlation.
\item \code{anscombe.extended$N100} same as above but 100 samples
\item \code{anscombe.extended$N1000} same as above but 1000 samples
}
}
\usage{
anscombe.extended
}
\description{
The dataset extends 'anscombe' provided in the
standard R-package 'datasets'. All examples feature the same
correlation of 0.82, but different types of dependencies. The main aim was to extend the classical examples, which have
sample size 11, to larger sample sizes. This illustrates that the
implied problems of Pearson's correlation are not small sample
problems! Distance multicorrelation (which coincides in
this case with distance correlation) yields different values
for the datasets.
}
\details{
Note: Anscombe's quartett features further identical parameters
besides Pearson's correlation. The extended set is only
concerned with correlation.
}
\examples{

# Code which generates plots of all included data:

op = par(mfrow = c(3,5),mar = c(0.5,0.5,3,0.5))
for (name in c("N11","N100","N1000")) {
  for (i in 1:5) {
    x = anscombe.extended[[name]][,2*i-1]
    y = anscombe.extended[[name]][,2*i]
  plot(x,y,main = paste0("cor = ",round(cor(x,y),2),
     "\n Mcor = ",round(multicorrelation(cbind(x,y),type = "pairwise",squared = FALSE),2)),
     axes = FALSE,xlab ="",ylab = "")
  # for two variables 'pairwise' coincides with
  # both values of 'total.upper.lower'.
  box()
  }
}
par(op)

}
\references{
This example was introduced in the reference [6] given on the main help page of this package: \link{multivariance-package}.
}
\keyword{datasets}
