% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{m.multivariance}
\alias{m.multivariance}
\title{m distance multivariance}
\usage{
m.multivariance(x, vec = NA, m = 2, Nscale = TRUE, Escale = TRUE,
  squared = TRUE, ...)
}
\arguments{
\item{x}{either a data matrix or an array of centered distance matrices}

\item{vec}{if x is a matrix, then this indicates which columns are treated together as one sample; if x is an array, these are the indexes for which the multivariance is calculated. The default is all columns and all indexes, respectively.}

\item{m}{\code{=2} or \code{3} the m-multivariance will be computed.}

\item{Nscale}{if \code{TRUE} the multivariance is scaled up by the sample size (and thus it is exactly as required for the test of independence)}

\item{Escale}{if \code{TRUE} then it is scaled by the number of multivariances which are theoretically summed up (this yields an expectation of 1 in the case of independence)}

\item{squared}{if \code{FALSE} it returns the actual multivariance, otherwise the squared multivariance (less computation)}

\item{...}{these are passed to \code{\link{cdms}} (which is only invoked if \code{x} is a matrix)}
}
\description{
Computes m distance multivariance.
}
\details{
m-distance multivariance is per definition the scaled sum of certain distance multivariances, and it characterize m-dependence.

 As a rough guide to interpret the value of total distance multivariance note:
\itemize{
\item Large values indicate dependence.
\item If the random variables are (m-1)-independent and \code{Nscale = TRUE}, values close to 1 and smaller indicate m-independence, larger values indicate dependence. In fact, in the case of independence the test statistic is a gaussian quadratic form with expectation 1 and samples of it can be generated by \code{\link{resample.multivariance}}.
\item If the random variables are (m-1)-independent and \code{Nscale = FALSE}, small values (close to 0) indicate m-independence, larger values indicate dependence.
}

Since random variables are always 1-independent, the case \code{m=2} characterizes pairwise independence.

Finally note, that due to numerical (in)precision the value of m-multivariance might become negative. In these cases it is set to 0. A warning is issued, if the value is negative and further than the usual (used by \code{\link[base]{all.equal}}) tolerance away from 0.
}
\examples{
x = matrix(rnorm(3*30),ncol = 3)

# the following values are identical
m.multivariance(x,m =2)
1/choose(3,2)*(multivariance(x[,c(1,2)]) +
               multivariance(x[,c(1,3)]) +
               multivariance(x[,c(2,3)]))

# the following values are identical
m.multivariance(x,m=3)
multivariance(x)

# the following values are identical
1/4*(3*(m.multivariance(x,m=2)) + m.multivariance(x,m=3))
total.multivariance(x, Nscale = TRUE)
1/4*(multivariance(x[,c(1,2)], Nscale = TRUE) +
     multivariance(x[,c(1,3)], Nscale = TRUE) +
     multivariance(x[,c(2,3)], Nscale = TRUE) + multivariance(x, Nscale = TRUE))

}
\references{
For the theoretic background see the reference [3] given on the main help page of this package: \link{multivariance-package}.
}
