% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_dic-class.R
\name{print.nma_dic}
\alias{print.nma_dic}
\alias{as.data.frame.nma_dic}
\alias{as.tibble.nma_dic}
\alias{as_tibble.nma_dic}
\alias{as.array.nma_dic}
\alias{as.matrix.nma_dic}
\title{Methods for \code{nma_dic} objects}
\usage{
\method{print}{nma_dic}(x, digits = 1, ...)

\method{as.data.frame}{nma_dic}(x, ...)

\method{as.tibble}{nma_dic}(x, ...)

\method{as_tibble}{nma_dic}(x, ...)

\method{as.array}{nma_dic}(x, ...)

\method{as.matrix}{nma_dic}(x, ...)
}
\arguments{
\item{x}{An object of class \link{nma_dic}}

\item{digits}{Integer number of digits to display}

\item{...}{Additional arguments passed on to other methods}
}
\value{
A \code{data.frame} for \code{as.data.frame()}, a \code{tbl_df} for \code{as.tibble()}
and \code{as_tibble()}, a \code{matrix} for \code{as.matrix()}, and an \code{mcmc_array} for
\code{as.array()}.

The \code{print()} method returns \code{x} invisibly.
}
\description{
The \code{print()} method prints details of DIC model fit statistics, computed by
the  \code{\link[=dic]{dic()}} function. The \code{as.data.frame()}, \code{as_tibble()}, and \code{as.tibble()} methods return the
pointwise contributions to the DIC and $p_D$ in a data frame or tibble. The \code{as.array()} and \code{as.matrix()}
methods returns a 3D MCMC array (as class \link{mcmc_array}) or matrix of posterior draws of the residual deviances.
}
\seealso{
\code{\link[=dic]{dic()}}, \code{\link[=plot.nma_dic]{plot.nma_dic()}}
}
