% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hta_psoriasis}
\alias{hta_psoriasis}
\title{HTA Plaque Psoriasis}
\format{
A data frame with 39 rows and 9 variables:
\describe{
\item{studyn}{numeric study ID}
\item{studyc}{study name}
\item{year}{year of publication}
\item{trtn}{numeric treatment code}
\item{trtc}{treatment name}
\item{sample_size}{sample size in each arm}
\item{PASI50, PASI75, PASI90}{ordered multinomial outcome counts (exclusive, see details)}
}
}
\usage{
hta_psoriasis
}
\description{
Data frame containing the results of 16 trials comparing 8 treatments for
moderate-to-severe plaque psoriasis from an HTA report
\insertCite{Woolacott2006}{multinma}, analysed in TSD2
\insertCite{TSD2}{multinma}. Outcomes are success/failure to achieve 50\%,
75\%, or 90\% reduction in symptoms on the Psoriasis Area and Severity Index
(PASI) scale. Some studies report all three ordered outcomes, others only one
or two. The latter are coded as missing values (see details).
}
\details{
Outcome counts are "exclusive"; that is, for a study reporting all
outcomes, the counts represent the categories 50 < PASI < 75, 75 < PASI <
90, and 90 < PASI < 100, and are named by the lower end of the interval.
(As opposed to "inclusive" counts, which would represent the overlapping
categories PASI > 50, PASI > 70, and PASI > 90.) The count for the fourth
category (the lowest), 0 < PASI < 50, is equal to \code{sample_size - PASI50 - PASI75 - PASI90}.

Missing values are used where studies only report a subset of the outcomes.
For a study reporting only two outcomes, say 50 and 75, the counts
represent 50 < PASI < 75 and 75 < PASI < 100. For a study reporting only
one outcome, say PASI 75, the count represents 75 < PASI < 100.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
