% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{modelCompare.merMod}
\alias{modelCompare.merMod}
\title{Compare two lmer models}
\usage{
\method{modelCompare}{merMod}(model1, model2, ...)
}
\arguments{
\item{model1}{A model estimated by \code{lmer}.}

\item{model2}{A model estimated by \code{lmer}.}

\item{...}{Additional arguments, not currently used but included to match generic.}
}
\value{
a data table with the fit indices for each model
and comparing models to each other.
}
\description{
This function provides fit statistics and effect sizes for
model comparisons.  The models must be nested.
}
\examples{

library(JWileymisc)
data(aces_daily, package = "JWileymisc")
m1 <- lme4::lmer(PosAff ~ STRESS + (1 + STRESS | UserID),
  data = aces_daily)
m2 <- lme4::lmer(PosAff ~ STRESS + (1 | UserID),
  data = aces_daily)
m3 <- lme4::lmer(PosAff ~ STRESS + Female + (1 | UserID),
  data = aces_daily)

modelCompare(m1, m2)
modelCompare(m2, m3)

rm(m1, m2, m3)
}
\references{
For estimating the marginal and conditional R-squared values,
  see: Nakagawa, S. and Schielzeth, H. (2013). A general and simple method
  for obtaining R2 from generalized linear mixed-effects models.
  Methods in Ecology and Evolution, 4(2), 133-142. as well as:
  Johnson, P. C. (2014). Extension of Nakagawa & Schielzeth's R2GLMM to
  random slopes models. Methods in Ecology and Evolution, 5(9), 944-946.
}
\keyword{utils}
