% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_index.R
\name{multilateral}
\alias{multilateral}
\alias{print.multilateral}
\title{Multilateral price index calculation}
\usage{
multilateral(
  period,
  price,
  index_method,
  check_inputs_ind = TRUE,
  verbose = FALSE,
  ...
)

\method{print}{multilateral}(x, ...)
}
\arguments{
\item{period}{vector of the periods corresponding to price observations. \cr
NOTE: \code{period} must be of class Date or numeric.}

\item{price}{vector of prices}

\item{index_method}{The index method of choice}

\item{check_inputs_ind}{logical, whether to check inputs or not}

\item{verbose}{print additional information to console}

\item{...}{All other possible arguments, see details}

\item{x}{multilateral class object}
}
\value{
A list object of length 3 containing; 

\code{index}, a data.frame of the final spliced price index based on the method specified \cr
\code{index_windows}, a data.frame containing each individual windows index before splicing \cr 
\code{splice_detail}, a data.frame containing the breakdown of splice information\cr
}
\description{
A flexible implementation of multilateral price index calculation for scanner
data. This function can be applied on any dataset where key attributes
exist (depending on method). Those are in general terms a period, ID, price,
and quantity. It will allow for extension of the method by the use of
calculation over a window of time and splicing them together.
}
\details{
The function takes vectors for each of the inputs. It is important to note
that the \code{period} argument must be of numeric or Date class. This is
because the order of the dates matters. \cr \cr The function also has the
capability to run in parallel, using the \code{num_cores} argument. Note that
for smaller datasets using non-parallel code is often faster than using
parallelisation due to the overhead associated with dividing the job across
multiple cores.

\code{...} represents all other possible arguments the user can provide, they
include: id, quantity, weight, features, splice_method, window_length, matched, chain_method,
num_cores

\code{index_method} can be one of 'TPD', 'TDH',
'GEKS-J','GEKS-F','GEKS-T', or 'GEKS-IT' you can view the configuration
file found under inst/config/index_method_config for more information

\code{splice_method} can be one of 'half','window','movement','geomean', or
'geomean_short' you can view the configuration file found under
inst/config/splice_method_config for more information
}
\examples{
tpd_index <- multilateral(period = turvey$month,
                          id = turvey$commodity,
                          price = turvey$price,
                          quantity = turvey$quantity,
                          splice_method = "geomean",
                          window_length = 13,
                          index_method = "TPD")
}
