% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop_css.R
\name{chop_css}
\alias{chop_css}
\title{chop_css}
\usage{
chop_css(cs1, cs2, data, subj, cs_paired = NULL, group = NULL, na.rm = FALSE)
}
\arguments{
\item{cs1}{The column name(s) of the conditioned responses for the first conditioned stimulus}

\item{cs2}{The column name(s) of the conditioned responses for the second conditioned stimulus}

\item{data}{A data frame containing all the relevant columns for the analyses}

\item{subj}{The name of the column including the participant numbers. Unique numbers are expected}

\item{cs_paired}{A character vector with the trials that were paired. Default is set to \code{NULL}, suggesting that there was full reinforcement
 @return A tibble with the following column names -- separately forr cs1 and cs2:
"id" = id column;
"top10per" = mean of top 10% of trials;
"bottom10per" = mean of bottom 10% of the trials;
"minfirst = all trials minus the first one;
"all" = mean of all trials;
"t33per = mean of top 33% of the trials;
"m33per" = mean of medium 33% of the trials;
"b33per" = mean of bottom 33% of the trials;
"fhalf" = mean of first half of the trials;
"lhalf" = mean of last half of the trials;
"ftrial" = first trial;
"ltrial" = last trial;
"t20per" = mean of top 20% of the trials;
"b20per" = mean of bottom 20% of the trials;
"f2trial" = mean of first two trials;
"l2trial" = mean of last two trials;
"per2_X" = mean per two trials (i.e., block), with X referring to the number
of block.}

\item{group}{the name of the group, if included, default to \code{NULL}}

\item{na.rm}{Whether NAs should be removed, default to \code{FALSE}}
}
\description{
Function for separating the conditioned responses into multiple pieces for two CSs.
}
