% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_multinom_uc_emc_sel.R
\name{adjust_multinom_uc_emc_sel}
\alias{adjust_multinom_uc_emc_sel}
\title{Adust for uncontrolled confounding, exposure misclassification, and selection
bias.}
\usage{
adjust_multinom_uc_emc_sel(
  data,
  exposure,
  outcome,
  confounders = NULL,
  x1u0_model_coefs,
  x0u1_model_coefs,
  x1u1_model_coefs,
  s_model_coefs,
  level = 0.95
)
}
\arguments{
\item{data}{Dataframe for analysis.}

\item{exposure}{String name of the exposure variable.}

\item{outcome}{String name of the outcome variable.}

\item{confounders}{String name(s) of the confounder(s).
A maximum of three confounders are allowed.}

\item{x1u0_model_coefs}{The regression coefficients corresponding to the
model: \ifelse{html}{\out{log(P(X=1,U=0)/P(X=0,U=0)) =
&gamma;<sub>1,0</sub> + &gamma;<sub>1,1</sub>X* +
&gamma;<sub>1,2</sub>Y + &gamma;<sub>1,2+j</sub>C<sub>j</sub>, }where X
is the true (binary) exposure, U is the (binary) unmeasured confounder,
X* is the (binary) misclassified exposure, Y is the (binary) outcome, C
represents the vector of (binary) measured confounders (if any), and
j corresponds to the number of measured
confounders.}{\eqn{log(P(X=1,U=0)/P(X=0,U=0)) =}}}

\item{x0u1_model_coefs}{The regression coefficients corresponding to the
model: \ifelse{html}{\out{log(P(X=0,U=1)/P(X=0,U=0)) =
&gamma;<sub>2,0</sub> + &gamma;<sub>2,1</sub>X* +
&gamma;<sub>2,2</sub>Y + &gamma;<sub>2,2+j</sub>C<sub>j</sub>, } where X
is the true (binary) exposure, U is the (binary) unmeasured confounder,
X* is the (binary) misclassified exposure, Y is the (binary) outcome,
C represents the vector of (binary) measured confounders (if any), and
j corresponds to the number of measured
confounders.}{\eqn{log(P(X=0,U=1)/P(X=0,U=0)) =}}}

\item{x1u1_model_coefs}{The regression coefficients corresponding to the
model: \ifelse{html}{\out{log(P(X=1,U=1)/P(X=0,U=0)) =
&gamma;<sub>3,0</sub> + &gamma;<sub>3,1</sub>X* +
&gamma;<sub>3,2</sub>Y + &gamma;<sub>3,2+j</sub>C<sub>j</sub>, } where X
is the true (binary) exposure, U is the (binary) unmeasured confounder,
X* is the (binary) misclassified exposure, Y is the (binary) outcome,
C represents the vector of (binary) measured confounders (if any),
and j corresponds to the number of measured
confounders.}{\eqn{log(P(X=1,U=1)/P(X=0,U=0)) =}}}

\item{s_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(S=1)) = &beta;<sub>0</sub> +
&beta;<sub>1</sub>X* + &beta;<sub>2</sub>Y +
&beta;<sub>2+j</sub>C<sub>j</sub>, } where S represents (binary) selection,
X* is the (binary) misclassified exposure, Y is the (binary) outcome,
C represents the vector of (binary) measured confounders (if any), and
j corresponds to the number of measured confounders.}{\eqn{logit(P(S=1)) =}}}

\item{level}{Value from 0-1 representing the full range of the confidence
interval. Default is 0.95.}
}
\value{
A list where the first item is the odds ratio estimate of the
 effect of the exposure on the outcome and the second item is the
 confidence interval as the vector: (lower bound, upper bound).
}
\description{
\code{adjust_multinom_uc_emc_sel} returns the exposure-outcome odds ratio and
confidence interval, adjusted for uncontrolled confounding, exposure
misclassificaiton, and selection bias.
}
\details{
This function uses one bias model, a multinomial logistic regression model,
to predict the uncontrolled confounder (U) and exposure (X). If separate bias
models for X and U are desired, use \code{adjust_uc_mc_2}.

Values for the regression coefficients can be applied as
fixed values or as single draws from a probability
distribution (ex: \code{rnorm(1, mean = 2, sd = 1)}). The latter has
the advantage of allowing the researcher to capture the uncertainty
in the bias parameter estimates. To incorporate this uncertainty in the
estimate and confidence interval, this function should be run in loop across
bootstrap samples of the dataframe for analysis. The estimate and
confidence interval would then be obtained from the median and quantiles
of the distribution of odds ratio estimates.
}
\examples{
adjust_multinom_uc_emc_sel(
  df_uc_emc_sel,
  exposure = "Xstar",
  outcome = "Y",
  confounders = c("C1", "C2", "C3"),
  x1u0_model_coefs = c(-2.78, 1.62, 0.61, 0.36, -0.27, 0.88),
  x0u1_model_coefs = c(-0.17, -0.01, 0.71, -0.08, 0.07, -0.15),
  x1u1_model_coefs = c(-2.36, 1.62, 1.29, 0.25, -0.06, 0.74),
  s_model_coefs = c(0.00, 0.26, 0.78, 0.03, -0.02, 0.10)
)

}
