% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Apply.R
\name{Apply}
\alias{Apply}
\title{Wrapper for Applying Atomic Functions to Arrays.}
\usage{
Apply(data, margins = NULL, AtomicFun, ..., inverse_margins = NULL, parallel = FALSE,
      ncores = NULL)
}
\arguments{
\item{data}{A single object (vector, matrix or array) or a list of objects. They must be in the same order as expected by AtomicFun.}

\item{margins}{List of vectors containing the margins for the input objects to be split by. Or, if there is a single vector of margins specified and a list of objects in data, then the single set of margins is applied over all objects. These vectors can contain either integers specifying the dimension position, or characters corresponding to the dimension names. If both margins and inverse_margins are specified, margins takes priority over inverse_margins.}

\item{AtomicFun}{Function to be applied to the arrays.}

\item{...}{Additional arguments to be used in the AtomicFun.}

\item{inverse_margins}{List of vectors containing the dimensions to be input into AtomicFun for each of the objects in the data. These vectors can contain either integers specifying the dimension position, or characters corresponding to the dimension names. If both margins and inverse_margins are specified, margins takes priority over inverse_margins.}

\item{parallel}{Logical, should the function be applied in parallel.}

\item{ncores}{The number of cores to use for parallel computation.}
}
\value{
Array or matrix or vector resulting from AtomicFun.
}
\description{
Takes lists of multidimensional objects as input, which may have different numbers of dimensions and dimension lengths. The user can specify which dimensions of each array (or matrix) the function is to be applied over with the margins option. 
}
\details{
A user can apply a function that receives 1 or more objects as input, each with a different number of dimensions, and returns as a result a single array with any number of dimensions.
}
\examples{
#Change in the rate of exceedance for two arrays, with different 
#dimensions, for some matrix of exceedances.
array_1 <- array(rnorm(2000), c(10,10,20)) # array with 20 timesteps
array_2 <- array(rnorm(1000), c(10, 10, 15)) # array with 15 timesteps
thresholds <- matrix(rnorm(100), 10, 10) # matrix of thresholds (no timesteps)

# Function for calculating the change in the frequency of exceedances over the
#thresholds for array_1 relative to array_2 (percentage change).

test_fun <- function(x, y, z) {(((sum(x > z) / (length(x))) / 
                                (sum(y > z) / (length(y)))) * 100) - 100}
data = list(array_1, array_2, thresholds)
margins = list(c(1, 2), c(1, 2), c(1,2))
test <- Apply(data = data, margins = margins, AtomicFun = "test_fun")
}
\references{
Wickham, H (2011), The Split-Apply-Combine Strategy for Data Analysis, Journal of Statistical Software.
}

