% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagPlot.R
\name{diagPlot}
\alias{diagPlot}
\title{Diagnosis Plot}
\usage{
diagPlot(
  hvt.results,
  data,
  level,
  quant.err,
  distance_metric = "L1_Norm",
  error_metric = "max",
  ...
)
}
\arguments{
\item{data}{Data frame. A data frame with different columns is given as input. The dataframe should be the same dataframe used to train the HVT Model}

\item{level}{Numeric. Indicating the level for which the heat map is
to be plotted.}

\item{quant.err}{Numeric. A number indicating the quantization error threshold.}

\item{...}{The ellipsis is passed to it as additional argument. (Used internally)}

\item{hvt.results.model}{A list of hvt.results.model obtained from HVT function while performing hierarchical vector quantization on train data}
}
\value{
A list that contains  a Minimum Inter-Centroid distance plot, a Minimum Intra-DataPoint Distance Plot,
Distribution of number of cells and count of singletons(segments with single observation)
\item{cent_plot }{Plot. a Minimum Intra-Centroid distance plot}
 \item{datapoint_plot }{Plot. a Minimum Intra-Datapoints distance plot} 
 \item{number_plot }{Plot. a Distribution of number of cells} 
\item{singleton_count}{Numeric. Count of singletons(segments with single observation)}
}
\description{
Function to construct Diagnosis Plots for HVT Model
}
\details{
This function creates Diagnosis Plots for HVT Model. The output of the functions contains a Minimum Intra-Centroid distance plot, a Minimum Intra-DataPoint Distance Plot,
Distribution of number of cells,  a Minimum Intra-DataPoint Distance Plot,
Distribution of number of cells and count of singletons(segments with single observation)
}
\examples{
data(USArrests)
hvt.results <- list()
hvt.results <- HVT(USArrests, n_cells = 15, depth = 1, quant.err = 0.2, 
                   distance_metric = "L1_Norm", error_metric = "mean",
                   projection.scale = 10, normalize = TRUE,
                   quant_method="kmeans",diagnose=TRUE)
diagPlot(hvt.results = hvt.results,
data = USArrests,
level = 1,
quant.err = 0.2)

}
\seealso{
\code{\link{predictHVT}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>
}
\keyword{hplot}
\keyword{internal}
