% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsd.r
\name{jsd}
\alias{jsd}
\title{Jensen-Shannon-Bregman distance}
\usage{
jsd(inm, pc = 1e-06)
}
\arguments{
\item{inm}{a numeric matrix or a data frame that comprises of non zero
positive entries.}

\item{pc}{Numeric. A small non-zero value to replace zero entries in the
vectors}
}
\value{
A distance matrix
}
\description{
Jensen-Shannon-Bregman distance d(x, y) between vectors x and y
}
\details{
Jensen-Shannon-Bregman distance \code{d(x, y)} between vectors \code{x} and
\code{y} is defined as: \cr \code{d(x, y) = sqrt(jsbd(x, y))} \cr \cr where:
\cr 1. \code{d(x, y)} is a metric. \cr 2. \code{x, y}: probability
distributions (i.e., \code{sum(x) = sum(y) = 1}) \cr 3. jsbd:
Jensen-Shannon-Bregman divergence, a symmetrized Bregman Divergence \cr 4.
\code{jsbd(x, y)}: JSB divergence between non-neg vectors x and y. \cr 5.
\code{jsbd(x, y) = 0.5 * (id(x, m) + id(y, m))} \cr \cr I-divergence is
defined as: \cr \code{id(x, y) = sum(x * log(x/y)) - sum(x) + sum(y)} \cr
\code{m = 0.5 * (x + y)} \cr

\code{inm} is the input matrix such that every row represents a non-neg
vector \cr Assumed: The matrix does not have any zero value. \cr

\code{id <- function(x, y) sum(x*log(x/y)) - sum(x) + sum(y)} \cr \code{jsd
<- function(x, y) sqrt(0.5 * (id(x, (x+y)/2) + id(y, (x+y)/2)))}
}
\note{
The limitation with this metric is that the divergence can be computed
only between positive vectors with non-zero components.
}
\examples{


data(sampledata)

dMat = jsd(sampledata)


}
\author{
Meet K. Dave <dave.kirankumar@mu-sigma.com>
}
