% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ess.R
\name{get_ess}
\alias{get_ess}
\title{Effective Sample Sizes of a mssm Object}
\usage{
get_ess(object)
}
\arguments{
\item{object}{an object of class \code{mssm}.}
}
\value{
An object of class \code{mssmEss} with the effective sample sizes.
}
\description{
Extracts the effective sample size at each time point from a \code{mssm}
object.
}
\examples{
if(require(Ecdat)){
  # load data and fit glm to get some parameters to use in an illustration
  data("Gasoline", package = "Ecdat")
  glm_fit <- glm(lgaspcar ~ factor(country) + lincomep + lrpmg + lcarpcap,
                 Gamma("log"), Gasoline)

  # get object to run particle filter
  library(mssm)
  ll_func <- mssm(
    fixed = formula(glm_fit), random = ~ 1, family = Gamma("log"),
    data = Gasoline, ti = year, control = mssm_control(
      N_part = 1000L, n_threads = 1L))

  # run particle filter
  pf <- ll_func$pf_filter(
    cfix = coef(glm_fit), disp = summary(glm_fit)$dispersion,
    F. = as.matrix(.0001), Q = as.matrix(.0001^2))

  # summary statistics for effective sample sizes
  print(ess <- get_ess(pf))
}
}
