% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{unpackMsg}
\alias{unpackMsg}
\alias{unpackMsgs}
\alias{unpackOpts}
\title{Decode msgpack messages.}
\usage{
unpackMsg(x, ...)

unpackMsgs(x, n = NA, reader = NULL, ...)

unpackOpts(parent = NULL, df = TRUE, simplify = TRUE, max_size = NA,
  max_depth = NA, underflow_handler = NULL)
}
\arguments{
\item{x}{A \code{\link[=raw]{raw()}} object, perhaps read from a file or socket.}

\item{...}{Options passed to \link{unpackOpts}.}

\item{n}{How many messages to read. An "NA" here means to read as
much as possible.}

\item{reader}{For implementing connections; a function that takes
no arguments and returns a raw containing more data.}

\item{parent}{When an environment is given, (such as \code{\link[=emptyenv]{emptyenv()}}),
unpack msgpack dicts into environment objects, with the given
value as parent. This option overrides \code{use_df=TRUE}. Otherwise,
unpack dicts into named vectors / lists.}

\item{df}{When \code{TRUE}, convert msgpack dicts, whose elements are
all arrays having the same length, into \code{\link[=data.frame]{data.frame()}}s.}

\item{simplify}{If \code{TRUE}, simplify msgpack lists into primitive
vectors.}

\item{max_size}{The maximum length of message to decode.}

\item{max_depth}{The maximum degree of nesting to support.}

\item{underflow_handler}{Used internally.}
}
\value{
\code{unpackMsg(x)} returns one decoded message (which might be
shorter than the input raw), or throws an error.

\code{unpackMsgs(r, n)} returns a list \code{X} with four elements:
\itemize{
\item \code{X$msgs} is a list of the messages unpacked.
\item \code{X$remaining} is data remaining to be parsed.
\item \code{X$status} is a status message, typically "ok", "end of input",
or "buffer underflow".
\item \code{x$bytes_read} the number of bytes consumed.
}
}
\description{
\code{unpackMsg} converts a raw array containing one message in msgpack
format into the corresponding R data structure.

\code{unpackMsgs} extracts a number of msgpack messages from a raw object.

\code{\link[=unpackOpts]{unpackOpts()}} interprets is passed to \code{...} in \code{\link[=unpackMsgs]{unpackMsgs()}},
\code{\link[=unpackMsg]{unpackMsg()}}, and \code{\link[=msgConnection]{msgConnection()}}. It is not exported.
}
\details{
The msgpack format does not have typed arrays, so all msgpack
arrays are effectively lists from the R perspective. However, if an
array containing compatibly typed elements is read, \code{unpack} will
return a logical, integer, real or string vector as
appropriate. This behavior is disabled with \code{simplify=FALSE}.  The
coercion used is more conservative than R's coercion: Integer
values may be converted to real, but boolean values will not be
cast to numeric, nor any types to string. If conversion from a
large integer to real loses precision, a warning is printed.

Msgpack also does not distinguish between \code{NA} and \code{NULL}. All nils
will be decoded as NA.

Strings are assumed to be UTF-8 encoded. If a msgpack string does
not appear to be valid UTF-8, a warning is printed and a raw object
is produced instead.

Msgpack allows any type to be the key of a dict, but R only
supports strings. If a non-string appears as key in a msgpack dict,
it will be converted to string with \code{\link[=deparse]{deparse()}}.

Extension types will be decoded as raw objects with a class like
\code{"ext120"} and a warning.
}
\examples{
msg <- as.raw(c(0x82, 0xa7, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0xc3,
                0xa6, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x00))
unpackMsg(msg)
x <- packMsgs(list("one", "two", "three"))
unpackMsgs(x, 2)
}
