% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_chart.R, R/mschart.R
\name{ms_linechart}
\alias{ms_linechart}
\alias{ms_barchart}
\alias{ms_areachart}
\alias{ms_scatterchart}
\alias{mschart}
\title{ms_chart object}
\usage{
ms_linechart(data, x, y, group = NULL)

ms_barchart(data, x, y, group = NULL)

ms_areachart(data, x, y, group = NULL)

ms_scatterchart(data, x, y, group = NULL)
}
\arguments{
\item{data}{a data.frame}

\item{x}{x colname}

\item{y}{y colname}

\item{group}{grouping colname used to split data into series. Optional.}
}
\description{
Creation of a chart object that can be
inserted in a 'Microsoft' document.
}
\section{Functions}{
\itemize{
\item \code{ms_linechart}: line plot

\item \code{ms_barchart}: bar plot

\item \code{ms_areachart}: area plot

\item \code{ms_scatterchart}: scatter plot
}}

\examples{
library(officer)


##########################
# linecharts example -----
##########################

mytheme <- mschart_theme(
  axis_title_x = fp_text(color = "red", font.size = 24, bold = TRUE),
  axis_title_y = fp_text(color = "green", font.size = 12, italic = TRUE),
  grid_major_line_y = fp_border(width = 1, color = "orange"),
  axis_ticks_y = fp_border(width = 1, color = "orange") )

# example lc_01 -------
lc_01 <- ms_linechart(data = iris, x = "Sepal.Length",
                      y = "Sepal.Width", group = "Species")
lc_01 <- chart_ax_y(lc_01, num_fmt = "0.00", rotation = -90)
lc_01 <- set_theme(lc_01, mytheme)


# example lc_02 -------
lc_02 <- ms_linechart(data = browser_ts, x = "date",
                      y = "freq", group = "browser")
lc_02 <- chart_ax_y(lc_02, cross_between = "between", num_fmt = "General")
lc_02 <- chart_ax_x(lc_02, cross_between = "midCat", num_fmt = "m/d/yy")
lc_02 <- set_theme(lc_02, mytheme)


# example lc_03 -------
lc_03 <- ms_linechart(data = browser_ts, x = "date",
                      y = "freq", group = "browser")
lc_03 <- chart_ax_x(lc_03, cross_between = "midCat", num_fmt = "m/d/yy")
lc_03 <- chart_settings(lc_03, grouping = "percentStacked")



##########################
# barcharts example -----
##########################

# example my_barchart_01 -------

my_barchart_01 <- ms_barchart(data = browser_data, x = "browser",
                           y = "value", group = "serie")
my_barchart_01 <- chart_settings( x = my_barchart_01, dir="vertical",
                               grouping="clustered", gap_width = 50 )
my_barchart_01 <- chart_ax_x( x= my_barchart_01, cross_between = 'between',
                           major_tick_mark="out")
my_barchart_01 <- chart_ax_y( x= my_barchart_01, cross_between = "midCat",
                           major_tick_mark="in")


# example my_barchart_02 -------

dat <- structure(list(Species = structure(1:3, .Label = c("setosa",
  "versicolor", "virginica"), class = "factor"), mean = c(5.006,
  5.936, 6.588)), class = "data.frame", .Names = c("Species", "mean"
  ), row.names = c(NA, -3L))

my_barchart_02 <- ms_barchart(data = dat, x = "Species", y = "mean")
my_barchart_02 <- chart_settings( x = my_barchart_02, dir="horizontal" )



# example my_barchart_03 -------

mytheme <- mschart_theme(
  axis_title_x = fp_text(color = "red", font.size = 24, bold = TRUE),
  axis_title_y = fp_text(color = "green", font.size = 12, italic = TRUE),
  grid_major_line_y = fp_border(width = 1, color = "orange"),
  axis_ticks_y = fp_border(width = 1, color = "orange") )

my_barchart_03 <- ms_barchart(data = browser_data, x = "browser",
                              y = "value", group = "serie")
my_barchart_03 <- chart_settings( my_barchart_03, dir="horizontal", grouping="stacked",
                                  gap_width = 150, overlap = 100 )
my_barchart_03 <- chart_ax_x(my_barchart_03, cross_between = 'between',
                             major_tick_mark="out", minor_tick_mark = "none")
my_barchart_03 <- chart_ax_y(my_barchart_03, num_fmt = "0.00", rotation = -90,
                             minor_tick_mark = "none")
my_barchart_03 <- set_theme(my_barchart_03, mytheme)
my_barchart_03 <- chart_data_labels(my_barchart_03, position = "inBase",
                                    show_val = TRUE, separator = ", ", show_cat_name = TRUE)




##########################
# areacharts example -----
##########################

mytheme <- mschart_theme(
  axis_title_x = fp_text(color = "red", font.size = 24, bold = TRUE),
  axis_title_y = fp_text(color = "green", font.size = 12, italic = TRUE),
  grid_major_line_y = fp_border(width = 1, color = "orange"),
  axis_ticks_y = fp_border(width = 1, color = "orange") )

# example ac_01 -------
ac_01 <- ms_areachart(data = iris, x = "Sepal.Length",
                      y = "Sepal.Width", group = "Species")
ac_01 <- chart_ax_y(ac_01, num_fmt = "0.00", rotation = -90)
ac_01 <- set_theme(ac_01, mytheme)


# example ac_02 -------
ac_02 <- ms_areachart(data = browser_ts, x = "date",
                      y = "freq", group = "browser")
ac_02 <- chart_ax_y(ac_02, cross_between = "between", num_fmt = "General")
ac_02 <- chart_ax_x(ac_02, cross_between = "midCat", num_fmt = "m/d/yy")
ac_02 <- set_theme(ac_02, mytheme)


# example ac_03 -------
ac_03 <- ms_areachart(data = browser_ts, x = "date",
                      y = "freq", group = "browser")
ac_03 <- chart_ax_x(ac_03, cross_between = "midCat", num_fmt = "m/d/yy")
ac_03 <- chart_settings(ac_03, grouping = "percentStacked")



##########################
# scattercharts example -----
##########################

# example sc_01 -------
sc_01 <- ms_scatterchart(data = mtcars, x = "disp",
                         y = "drat")
sc_01 <- chart_ax_x(sc_01, cross_between = "midCat")
sc_01 <- chart_settings(sc_01, scatterstyle = "marker")


}
