% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amnet.R
\name{amnet}
\alias{amnet}
\title{Adaptive MCP-Net}
\usage{
amnet(x, y, family = c("gaussian", "binomial", "poisson", "cox"),
  init = c("mnet", "ridge"), nfolds = 5L, gammas = c(1.01, 1.7, 3, 100),
  alphas = seq(0.05, 0.95, 0.05), gamma = 1, seed = 1001,
  parallel = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response vector if \code{family} is \code{"gaussian"},
\code{"binomial"} or \code{"poisson"}.
If \code{family} is \code{"cox"}, a response matrix made by
\code{\link[survival]{Surv}}.}

\item{family}{Model family, can be \code{"gaussian"},
\code{"binomial"}, \code{"poisson"}, or \code{"cox"}.}

\item{init}{Type of the penalty used in the initial
estimation step. Can be \code{"mnet"} or \code{"ridge"}.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{gammas}{Vector of candidate \code{gamma}s to use in MCP-Net.}

\item{alphas}{Vector of candidate \code{alpha}s to use in MCP-Net.}

\item{gamma}{Scaling factor for adaptive weights:
\code{weights = coefs^(-gamma)}.}

\item{seed}{Random seed for cross-validation fold division.}

\item{parallel}{Logical. Enable parallel parameter tuning or not,
default is {FALSE}. To enable parallel tuning, load the
\code{doParallel} package and run \code{registerDoParallel()}
with the number of CPU cores before calling this function.}

\item{verbose}{Should we print out the estimation progress?}
}
\value{
List of coefficients \code{beta} and
\code{ncvreg} model object \code{model}.
}
\description{
Adaptive MCP-Net
}
\examples{
dat = msaenet.sim.gaussian(n = 150, p = 500, rho = 0.6,
                           coef = rep(1, 5), snr = 2, p.train = 0.7,
                           seed = 1001)

amnet.fit = amnet(dat$x.tr, dat$y.tr,
                  gammas = 3, alphas = seq(0.2, 0.8, 0.2), seed = 1002)

print(amnet.fit)
msaenet.nzv(amnet.fit)
msaenet.fp(amnet.fit, 1:5)
msaenet.tp(amnet.fit, 1:5)
amnet.pred = predict(amnet.fit, dat$x.te)
msaenet.rmse(dat$y.te, amnet.pred)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}

