% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_sir_results.R
\name{summarize_sir_results}
\alias{summarize_sir_results}
\title{Summarize detailed SIR results}
\usage{
summarize_sir_results(
  sir_df,
  summarize_groups,
  summarize_site = FALSE,
  output = "long",
  output_information = "full",
  add_total_row = "no",
  add_total_fu = "no",
  collapse_ci = FALSE,
  shorten_total_cols = FALSE,
  fubreak_var_name = "fu_time",
  ybreak_var_name = "yvar_name",
  xbreak_var_name = "none",
  site_var_name = "t_site",
  alpha = 0.05
)
}
\arguments{
\item{sir_df}{dataframe with stratified sir results created using the sir or sir_byfutime functions}

\item{summarize_groups}{option to define summarizing stratified groups. Default is "none".
If you want to define variables that should be summarized into one group, you can chose from age, sex, region, year.
Define multiple summarize variables e.g. by summarize_groups = c("region", "sex", "year")}

\item{summarize_site}{If TRUE results will be summarized over all t_site categories. Default is FALSE.}

\item{output}{Define the format of the output.
Can be either "nested" for nested dataframe with fubreak_var and xbreak_var in separate sub_tables (purrr).
Or "wide" for wide format where fubreak_var and xbreak_var are appended as columns.
Or "long" for long format where sir_df is not reshaped, but just summarized (ybreak_var, xbreak_var and fubreak_var remain in rows).
Default is "long".}

\item{output_information}{option to define information to be presented in final output table. Default is "full" information, i.e. all variables from
from sir_df. "reduced" is observed, expected, sir, sir_ci / sir_lci+sir_uci, pyar, n_base. "minimal" is observed, expected, sir, sir_ci.
Default is "full".}

\item{add_total_row}{option to add a row of totals. Can be either "no" for not adding such a row or "start" or "end" for adding it at the first or last row
or "only" for only showing totals and no yvar. Default is "no".}

\item{add_total_fu}{option to add totals for follow-up time. Can be either "no" for not adding such a column or "start" or "end" for adding it at the first or last column
or "only" for only showing follow-up time totals. Default is "no".}

\item{collapse_ci}{If TRUE upper and lower confidence interval will be collapsed into one column separated by "-". Default is FALSE.}

\item{shorten_total_cols}{Shorten text in all results columns that start with "Total". Default == FALSE.}

\item{fubreak_var_name}{Name of variable with futime stratification. Default is "fu_time".}

\item{ybreak_var_name}{Name of variable with futime stratification. Default is "yvar_name".}

\item{xbreak_var_name}{Name of variable with futime stratification. Default is "xvar_name".}

\item{site_var_name}{Name of variable with site stratification. Default is "t_site".}

\item{alpha}{significance level for confidence interval calculations. Default is alpha = 0.05 which will give 95 percent confidence intervals.}
}
\description{
Summarize detailed SIR results
}
\examples{
#There are various preparation steps required, before you can run this function.
#Please refer to the Introduction vignette to see how to prepare your data
\dontrun{
summarize_sir_results(.,
    summarize_groups = c("region", "age", "year", "race"),
    summarize_site = TRUE,
    output = "long",  output_information = "minimal",
    add_total_row = "only",  add_total_fu = "no",
    collapse_ci = FALSE,  shorten_total_cols = TRUE,
    fubreak_var_name = "fu_time", ybreak_var_name = "yvar_name",
    xbreak_var_name = "none", site_var_name = "t_site",
    alpha = 0.05
    )
    }
    
}
