% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmxml.R
\name{nmext}
\alias{nmext}
\title{Import model estimates from a NONMEM ext file}
\usage{
nmext(
  run = NA_real_,
  project = getwd(),
  file = paste0(run, ".ext"),
  path = NULL,
  root = c("working", "cppfile"),
  index = "last",
  theta = TRUE,
  omega = TRUE,
  sigma = TRUE,
  olabels = NULL,
  slabels = NULL,
  oprefix = "",
  sprefix = "",
  tname = "THETA",
  oname = "...",
  sname = "...",
  read_fun = "data.table",
  env = NULL
)
}
\arguments{
\item{run}{run number}

\item{project}{project directory}

\item{file}{deprecated; use \code{path} instead}

\item{path}{full path to NONMEM \code{ext} file}

\item{root}{the directory that `path` and `project` are relative to; this is
currently limited to the `working` directory or `cppdir`, the directory 
where the model file is located}

\item{index}{the estimation number to return;  "last" will return the 
last estimation results; otherwise, pass an integer indicating which 
estimation results to return}

\item{theta}{logical; if TRUE, the \code{$THETA} vector is returned}

\item{omega}{logical; if TRUE, the \code{$OMEGA} matrix is returned}

\item{sigma}{logical; if TRUE, the \code{$SIGMA} matrix is returned}

\item{olabels}{labels for \code{$OMEGA}}

\item{slabels}{labels for \code{$SIGMA}}

\item{oprefix}{prefix for \code{$OMEGA} labels}

\item{sprefix}{prefix for \code{$SIGMA} labels}

\item{tname}{name for \code{$THETA}}

\item{oname}{name for \code{$OMEGA}}

\item{sname}{name for \code{$SIGMA}}

\item{read_fun}{function to use when reading the \code{ext} file}

\item{env}{internal}
}
\description{
Import model estimates from a NONMEM ext file
}
\seealso{
\code{\link[=nmxml]{nmxml()}}, \code{\link[=read_nmext]{read_nmext()}}
}
