% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{ev_days}
\alias{ev_days}
\title{Schedule dosing events on days of the week.}
\usage{
ev_days(ev = NULL, days = "", addl = 0, ii = 168, unit = c("hours",
  "days"), ...)
}
\arguments{
\item{ev}{an event object}

\item{days}{comma- or space-separated character string of valid days of the
the week (see details)}

\item{addl}{additional doses to administer}

\item{ii}{inter-dose interval; intended use is to keep this at the 
default value}

\item{unit}{time unit; the function can only currently handle hours or days}

\item{...}{event objects named by one the valid days of the week (see details)}
}
\description{
This function lets you schedule doses on specific 
days of the week, allowing you to create dosing 
regimens on Monday/Wednesday/Friday, or Tuesday/Thursday,
or every other day (however you want to define that) etc.
}
\details{
Valid names of the week are: 

\itemize{
\item \code{m} for Monday
\item \code{t} for Tuesday
\item \code{w} for Wednesday
\item \code{th} for Thursday
\item \code{f} for Friday
\item \code{sa} for Saturday
\item \code{s} for Sunday
}

The whole purpose of this function is to schedule doses on specific
days of the week, in a repeating weekly schedule.  Please do use caution 
when changing \code{ii} from it's default value.
}
\examples{

# Monday, Wednesday, Friday x 4 weeks
ev_days(ev(amt=100), days="m,w,f", addl=3)

# 50 mg Tuesdays, 100 mg Thursdays x 6 months
ev_days(t=ev(amt=50), th=ev(amt=100), addl=23)


}
