% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream.R
\name{format_stream}
\alias{format_stream}
\title{Set the format for a stream_file object}
\usage{
format_stream(
  x,
  type = c("fst", "feather", "qs", "rds"),
  set_ext = TRUE,
  warn = FALSE
)
}
\arguments{
\item{x}{A \code{file_stream} object.}

\item{type}{The file format type; if \code{feather} is chosen, then a check will
be made to ensure the \code{arrow} package is loaded.}

\item{set_ext}{If \code{TRUE}, the existing extension (if it exists) is stripped
and a new extension is added based on the value of \code{type}.}

\item{warn}{If \code{TRUE} a warning will be issued in case the output format
is set but there is no directory path associated with the \code{file} spot in
\code{x[[1]]}.}
}
\value{
\code{x} is returned with a new class attribute reflecting the expected output
format (\code{fst}, \code{feather} (arrow), \code{qs} or \code{rds}).
}
\description{
The format is set on the file objects inside the list so that the file
object can be used to call a write method. See \code{\link[=write_stream]{write_stream()}}.
}
\examples{
fs <- new_stream(2)
fs <- format_stream(fs, "fst")
fs[[1]]

format_is_set(fs[[1]])  
 
}
\seealso{
\code{\link[=format_is_set]{format_is_set()}}, \code{\link[=locate_stream]{locate_stream()}}, \code{\link[=ext_stream]{ext_stream()}},
\code{\link[=new_stream]{new_stream()}}, \code{\link[=file_stream]{file_stream()}}, \code{\link[=file_set]{file_set()}}
}
