% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrfi_class.R, R/mrfi_methods.R
\docType{class}
\name{mrfi-class}
\alias{mrfi-class}
\alias{as.list,mrfi-method}
\title{mrfi: MRF interaction structure}
\usage{
\S4method{as.list}{mrfi}(x)
}
\arguments{
\item{x}{\code{mrfi} object.}
}
\value{
\code{as.list()}: converts the \code{mrfi} object to a list of interacting
positions (list of length-2 vectors).
}
\description{
The \code{mrfi} S4 class is a representation of the interaction
structure for a spatially-stationary Markov Random Field.

The function \code{\link[=mrfi]{mrfi()}} provides an interface for creation
\code{mrfi} objects. A \code{plot} method is also available for visualization, as
well as conversion methods like \code{as.list} and operators like \code{+}.
}
\details{
The interaction structure is defined by the list of relative
positions in it. For a specific pixel, conditional to the values of pixels in
these relative positions from it, its value is independent of any other pixel
in the image.

The relative positions are indentified by two integers \code{rx} and \code{ry}
representing the "shift" in the \code{x}-axis and \code{y}-axis respectively. As an
example: The relative position \verb{(1,0)} representes the pixel in the immediate
right position, while \verb{(-1,0)} the left one.

Note that the inclusion of a relative position to the dependence also implies
its opposite direction is not conditionally independent (commutativeness of
dependence), but only one is actually included to the \code{mrfi} object.

To illustrate that, a nearest neighbor dependence structure can be specified
by:

\code{mrfi(1)}

Note that it only includes the positions \verb{(1,0)} and \verb{(0,1)}, but when
visualizing it, for example, \code{mrf2d} understands the opposite directions
are also conditionally dependent, as in

\code{plot(mrfi(1))}.
}
\section{Slots}{

\describe{
\item{\code{Rmat}}{A 2-column \code{matrix} where each row represents a relative position
of interaction.}
}}

\examples{
plot(mrfi(max_norm = 2, norm_type = "1"))
plot(mrfi(max_norm = 2, norm_type = "m"))
plot(mrfi(max_norm = 2, norm_type = "1", positions = list(c(4,4))))

as.list(mrfi(1))
mrfi(1)[[1]]
mrfi(2)[[1:3]]

}
\seealso{
A paper with detailed description of the package can be found at
\url{https://arxiv.org/abs/2006.00383}
}
