# testing for plotting functions

library(testthat)
library(mrds)

context("Plotting tests: average.line")

test_that("average.line for plot.io is correct (unconditional df)",{

  # load some data as usual
  data(book.tee.data)
  egdata <- book.tee.data$book.tee.dataframe

  # fit the model
  result <- ddf(dsmodel = ~cds(key = "hn"), mrmodel = ~glm(~distance),
                data = egdata, method = "io", meta.data = list(width = 4))

  # make the grid (as in plot.io)
  divisions <- 25 # default in plot.io
  finebr <- (4/divisions)*(0:divisions)

  ## observer 1
  # make the line
  aline <- mrds:::average.line(finebr,obs=1,result)
  # "true" values
  aline.truth <- c(0.942984310350384,0.931758960736299,0.916033134386296,
                   0.895960681152277,0.871766127423631,0.843743459341331,
                   0.812252811904826,0.777714776947772,0.740602126839018,
                   0.701428901443524,0.660737024685639,0.619080889235704,
                   0.577010639634571,0.535055145122935,0.493705825337338,
                   0.453402523523292,0.414522484905807,0.377373199698558,
                   0.342189456128584,0.309134492201619,0.278304718215714,
                   0.249737174975323,0.223418735462668,0.199296054654547,
                   0.177285396274316)
  expect_that(aline$value,equals(aline.truth,tol=1e-6))

  # obs == 3 (duplicates)
  aline <- mrds:::average.line(finebr,obs=3,result)
  aline.truth <- c(0.996674615155133,0.992654180180232,0.984661898293878,
                   0.972793968270969,0.957192272380195,0.938041553280893,
                   0.915565773567083,0.890023758238941,0.861704238583432,
                   0.830920430012759,0.79800428592961,0.763300574439644,
                   0.727160924687131,0.689937984912215,0.651979825357745,
                   0.613624706385435,0.575196316218169,0.536999564325613,
                   0.49931699639121,0.462405875840549,0.426495955861535,
                   0.391787945447792,0.35845265391595,0.326630781154814,
                   0.29643330601488)
  expect_that(aline$value,equals(aline.truth,tol=1e-6))

  # obs == 4 (pooled)
  aline <- mrds:::average.line(finebr,obs=4,result)
  aline.truth <- c(0.889294005545635,0.870863741292367,0.847404370478714,
                   0.819127394033584,0.786339982467066,0.749445365401769,
                   0.70893985024257,0.665405795656602,0.619500015094604,
                   0.57193737287429,0.523469763441668,0.474861204031765,
                   0.426860354582011,0.380172305333655,0.335431825316931,
                   0.293180340661149,0.253848653593445,0.217746835071503,
                   0.185061915865959,0.155863108562689,0.130113480569892,
                   0.107686404502854,0.0883848170093864,0.0719613281542805,
                   0.058137486533752)
  expect_that(aline$value,equals(aline.truth,tol=1e-6))


  ## for the simulated point data
  data(ptdata.dual)
  ptdata.dual$distbegin <- (as.numeric(cut(ptdata.dual$distance,
                                           10*(0:10)))-1)*10
  ptdata.dual$distend <- (as.numeric(cut(ptdata.dual$distance,10*(0:10))))*10

  model <- ddf(method="io", data=ptdata.dual, dsmodel=~cds(key="hn"),
               mrmodel=~glm(formula=~distance*observer),
               meta.data=list(point=TRUE, binned=TRUE,
                              breaks=10*(0:10),width=100))
  finebr <- (100/divisions)*(0:divisions)

  # obs==1
  aline <- mrds:::average.line(finebr,obs=1,model)
  aline.truth <- c(0.856946132968447,0.844599114030259,0.817745067947811,
                   0.777562707651769,0.725918882133155,0.665234725411972,
                   0.598292473748066,0.528009213300646,0.457209122941113,
                   0.388423691545203,0.323741781193399,0.264721047813952,
                   0.212361758319031,0.167135404249571,0.12905478402601,
                   0.0977696815384146,0.0726725604843198,0.0530010869108328,
                   0.0379278959421831,0.0266319796455126,0.0183497112799511,
                   0.0124063973398744,0.0082311701060649,0.00535901392610466,
                   0.003423913832683)
  expect_that(aline$value,equals(aline.truth,tol=1e-6))

  # obs==2
  aline <- mrds:::average.line(finebr,obs=2,model)
  aline.truth <- c(0.660565261401045,0.691847612349289,0.704081224631102,
                   0.696931939404776,0.671711967525353,0.631062200290702,
                   0.578504755459729,0.517963653623824,0.453330843743982,
                   0.388125518403408,0.32526678377014,0.266958223974622,
                   0.214668880727346,0.169187830176286,0.130727376132227,
                   0.0990513585779444,0.0736088542618773,0.0536585005922438,
                   0.0383739010110256,0.0269253861028954,0.018537355247498,
                   0.012523279734689,0.00830218169750567,0.00540114004009108,
                   0.00344833635941182)
  expect_that(aline$value,equals(aline.truth,tol=1e-6))

  # obs==3
  aline <- mrds:::average.line(finebr,obs=3,model)
  aline.truth <- c(0.946256738093447,0.928715717429257,0.89460313660252,
                   0.845769165809663,0.784778488332198,0.714687427988588,
                   0.638791318942099,0.560371035074794,0.482465388490667,
                   0.407690374079573,0.338118211049567,0.275220308922724,
                   0.21987011521244,0.172395426613796,0.132665832753061,
                   0.100199659326374,0.07427577858774,0.0540383389970281,
                   0.0385860728953481,0.0270416370791242,0.0185998392101543,
                   0.0125562284978859,0.00831922827697337,0.00540979343898331,
                   0.00345264665538174)
  expect_that(aline$value,equals(aline.truth,tol=1e-6))

  # obs==4
  aline <- mrds:::average.line(finebr,obs=4,model)
  aline.truth <- c(0.571254656276045,0.607731008950292,0.627223155976392,
                   0.628725481246882,0.61285236132631,0.581609497714085,
                   0.538005910265696,0.485601831849677,0.428074578194427,
                   0.368858835869039,0.310890353913971,0.256458962865849,
                   0.207160523833938,0.163927807812061,0.127116327405176,
                   0.0966213807899847,0.0720056361584571,0.0526212485060485,
                   0.0377157240578607,0.0265157286692839,0.0182872273172947,
                   0.0123734485766775,0.0082141235265972,0.00535036052721243,
                   0.00341960353671309)
  expect_that(aline$value,equals(aline.truth,tol=1e-6))



})
