% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_DC_stacked_barplot.R
\name{plot_DC_stacked_barplot}
\alias{plot_DC_stacked_barplot}
\title{Summary Barplot - Data Completeness}
\usage{
plot_DC_stacked_barplot(
  input_list,
  level = c("Precursor.IDs", "Peptide.IDs", "Protein.IDs", "ProteinGroup.IDs"),
  label = c("absolute", "percentage")
)
}
\arguments{
\item{input_list}{A list with data frames and respective level information.}

\item{level}{Character string. Choose between "Precursor.IDs", "Peptide.IDs", "Protein.IDs" or "ProteinGroup.IDs" for corresponding level. Default is "Precursor.IDs".}

\item{label}{Character string. Choose between "absolute" or "percentage". Default is "absolute".}
}
\value{
This function returns a stacked barplot.
}
\description{
Plot number of identifications per missing values as stacked barplot.
}
\details{
The analyses are summarized in a stacked barplot displaying information about the number of achieved identifications per missing values.
}
\examples{
# Load libraries
library(magrittr)
library(dplyr)
library(tibble)

# Example data
data <- list(
 "A" = tibble::tibble(
   Analysis = c("A", "A", "A"),
   Nr.Missing.Values = c(2, 1, 0),
   Precursor.IDs = c(50, 200, 4500),
   Peptide.IDs = c(30, 190, 3000),
   Protein.IDs = c(20, 40, 600),
   ProteinGroup.IDs = c(15, 30, 450),
   Profile = c("unique", "shared with at least 50\%", "complete")
 ),
 "B" = tibble::tibble(
   Analysis = c("B", "B", "B"),
   Nr.Missing.Values = c(2, 1, 0),
   Precursor.IDs = c(50, 180, 4600),
   Peptide.IDs = c(50, 170, 3200),
   Protein.IDs = c(20, 40, 500),
   ProteinGroup.IDs = c(15, 30, 400),
   Profile = c("unique", "shared with at least 50\%", "complete")
 )
)

# Plot
plot_DC_stacked_barplot(
  input_list = data,
  level = "Precursor.IDs",
  label = "absolute"
)
}
\author{
Oliver Kardell
}
