% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kch.R
\name{kch}
\alias{kch}
\title{Extract Metapop KCH}
\usage{
kch(meta, path)
}
\arguments{
\item{meta}{The R object holding Metapop metadata returned by
\code{\link{meta}}.}

\item{path}{A character string giving the full path to the directory
containing .kch files referred to in object \code{meta}.}
}
\value{
A \code{matrix} containing one column per population, giving the
  carrying capacity at each time step (i.e. each row).
}
\description{
Extract KCH time series for each RAMAS Metapop population.
}
\examples{
mp <- system.file('example.mp', package='mptools')
k <- kch(meta=meta(mp), path=dirname(mp))
}

