% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sixteenParentPedigreeRandomFunnels.R
\name{sixteenParentPedigreeRandomFunnels}
\alias{sixteenParentPedigreeRandomFunnels}
\title{Generate a sixteen-parent pedigree}
\usage{
sixteenParentPedigreeRandomFunnels(
  initialPopulationSize,
  selfingGenerations,
  nSeeds = 1L,
  intercrossingGenerations
)
}
\arguments{
\item{initialPopulationSize}{The number of F1 lines generated}

\item{selfingGenerations}{The number of selfing generations at the end of the pedigree}

\item{nSeeds}{The number of progeny taken from each intercrossing line, or from each F1 if no intercrossing is specified. These lines are then selfed according to selfingGenerations}

\item{intercrossingGenerations}{The number of generations of random mating performed from the F1 generation. Population size is maintained at that specified by initialPopulationSize}
}
\value{
An object of class \code{detailedPedigree} representing the experimental design, suitable for simulation using simulateMPCross.
}
\description{
Generate a sixteen-parent pedigree starting from inbred founders, using a random funnel
}
\seealso{
\code{\link{eightParentPedigreeSingleFunnel}}, \code{\link{fourParentPedigreeSingleFunnel}}, \code{\link{fourParentPedigreeRandomFunnels}}, \code{\link{twoParentPedigree}}
}
