% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_moveHMM.R
\name{plot.moveHMM}
\alias{plot.moveHMM}
\title{Plot \code{moveHMM}}
\usage{
\method{plot}{moveHMM}(x, animals = NULL, ask = TRUE, breaks = "Sturges",
  hist.ylim = NULL, sepAnimals = FALSE, sepStates = FALSE, col = NULL,
  ...)
}
\arguments{
\item{x}{Object \code{moveHMM}}

\item{animals}{Vector of indices or IDs of animals for which information will be plotted.
Default: \code{NULL}; all animals are plotted.}

\item{ask}{If \code{TRUE}, the execution pauses between each plot.}

\item{breaks}{Histogram parameter. See \code{hist} documentation.}

\item{hist.ylim}{Parameter \code{ylim} for the step length histograms.
See \code{hist} documentation. Default: \code{NULL} ; the function sets default values.}

\item{sepAnimals}{If \code{TRUE}, the data is split by individuals in the histograms.
Default: \code{FALSE}.}

\item{sepStates}{If \code{TRUE}, the data is split by states in the histograms.
Default: \code{FALSE}.}

\item{col}{Vector or colors for the states (one color per state).}

\item{...}{Currently unused. For compatibility with generic method.}
}
\description{
Plot the fitted step and angle densities over histograms of the data, transition probabilities
as functions of the covariates, and maps of the animals' tracks colored by the decoded states.
}
\details{
The state-dependent densities are weighted by the frequency of each state in the most
probable state sequence (decoded with the function \code{\link{viterbi}}). For example, if the
most probable state sequence indicates that one third of observations correspond to the first
state, and two thirds to the second state, the plots of the densities in the first state are
weighted by a factor 1/3, and in the second state by a factor 2/3.
}
\examples{
# m is a moveHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

plot(m,ask=TRUE,animals=1,breaks=20)


}

