% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Engines.R
\docType{data}
\name{Engines}
\alias{Engines}
\title{Characteristics of various internal combustion engines}
\format{
A data frame with 39 cases, each of which is an internal combustion engine, with observations on the following variables.
\itemize{
\item \code{mass} In pounds
\item \code{ncylinder} Number of cylinders
\item \code{stroke} The length  of the stroke made by a piston
\item \code{strokes} Whether the engine cycle is 2-stroke or 4-stroke.
\item \code{displacement} In cc
\item \code{bore} Diameter of the piston
\item \code{BHP} The power generated by  the engine. One BHP is the same as 745.7 Watts.
\item \code{RPM} The speed, in revolutions per second, at which the engine generates the listed BHP.
}
}
\source{
McMahon, Thomas A., and John Tyler Bonner. On Size and Life. New York: Scientific American Library, 1983. pp. 60-61
}
\usage{
data(Engines)
}
\description{
Internal combustion engines have been built for a variety of purposes
ranging from propelling small model airplanes to powering trucks to driving
the propellers of giant ships.  This data frame gives the characteristics
of a wide size range of such engines.
}
\keyword{datasets}
