% Generated by roxygen2 (4.0.2): do not edit by hand
\name{qdata}
\alias{cdata}
\alias{ddata}
\alias{pdata}
\alias{qdata}
\alias{rdata}
\title{The Data Distribution}
\usage{
qdata(p, vals, data = NULL, ...)

cdata(p, vals, data = NULL, ...)

pdata(q, vals, data = NULL, ...)

rdata(n, vals, data = NULL, ...)

ddata(q, vals, data = NULL, ...)
}
\arguments{
\item{p}{a vector of probabilities}

\item{vals}{a vector containing the data}

\item{data}{a data frame in which to evaluate vals}

\item{q}{a vector of quantiles}

\item{n}{number of values to sample}

\item{\dots}{additional arguments passed to \code{quantile} or \code{sample}}
}
\value{
For \code{qdata}, a vector of quantiles

for \code{cdata}, a named numerical vector or a data frame giving
upper and lower limits and the central proportion requested

For \code{pdata}, a vector of probabilities

For \code{rdata}, a vector of values sampled from \code{vals}

For \code{ddata}, a vector of probabilities (empirical densities)
}
\description{
Density, distribution function, quantile function, and random generation
from data.
}
\examples{
data(iris)
qdata(.5, Sepal.Length ~ Species, data=iris)
qdata(.5, ~Sepal.Length, groups=Species, data=iris)
qdata(.5, iris$Sepal.Length)
qdata(.5, Sepal.Length, data=iris)
qdata(.5, Sepal.Length, groups=Species, data=iris)
data(iris)
cdata(.5, iris$Sepal.Length)
cdata(.5, Sepal.Length, data=iris)
cdata_f(~Sepal.Length, data=iris, p=.5)
cdata_f(~Sepal.Length | Species, data=iris, p=.5)
data(iris)
pdata(3:6, iris$Sepal.Length)
pdata(3:6, Sepal.Length, data=iris)
pdata(3:6, ~Sepal.Length, data=iris)
pdata(3:6, Sepal.Length, data=iris)
data(iris)
rdata(10,iris$Species)
rdata(10, Species, data=iris)
rdata(10, ~Species, data=iris)
rdata(5, Sepal.Length~Species, data=iris)
data(iris)
ddata('setosa', iris$Species)
ddata('setosa', Species, data=iris)
ddata('setosa', ~Species, data=iris)
}
\keyword{distribution}

