% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pqrdata.R
\name{qdata}
\alias{cdata}
\alias{ddata}
\alias{pdata}
\alias{qdata}
\alias{rdata}
\title{The Data Distribution}
\usage{
qdata(formula, p = seq(0, 1, 0.25), data = NULL, ...)

cdata(formula, p = 0.95, data = NULL, ...)

pdata(formula, q, data = NULL, ...)

rdata(formula, n, data = NULL, ...)

ddata(formula, q, data = NULL, ...)
}
\arguments{
\item{formula}{a formula or a vector}

\item{p}{a vector of probabilities}

\item{data}{a data frame in which to evaluate \code{formula}}

\item{q}{a vector of quantiles}

\item{n}{number of values to sample}

\item{\dots}{additional arguments passed to \code{quantile} or \code{sample}}
}
\value{
For \code{qdata}, a vector of quantiles

for \code{cdata}, a named numerical vector or a data frame giving
upper and lower limits and the central proportion requested

For \code{pdata}, a vector of probabilities

For \code{rdata}, a vector of sampled values.

For \code{ddata}, a vector of probabilities (empirical densities)
}
\description{
Density, distribution function, quantile function, and random generation
from data.
}
\examples{
data(iris)
qdata(Sepal.Length ~ Species, 0.5, data=iris)
qdata(~Sepal.Length, p = 0.5, groups=Species, data=iris)
qdata(iris$Sepal.Length, p = 0.5)
qdata(~ Sepal.Length, p = 0.5, data=iris)
qdata(~ Sepal.Length, p = 0.5, groups=Species, data=iris)
data(iris)
cdata(iris$Sepal.Length, 0.5)
cdata( ~ Sepal.Length, 0.5, data = iris)
cdata( ~ Sepal.Length, 0.5, data = iris)
cdata( ~ Sepal.Length | Species, data = iris, p = .5)
data(iris)
pdata(iris$Sepal.Length, 3:6)
pdata( ~ Sepal.Length, 3:6, data=iris)
data(iris)
rdata(iris$Species, 10)
rdata(~Species, n = 10, data=iris)
rdata(Sepal.Length ~ Species,  n = 5, data=iris)
data(iris)
ddata(iris$Species, 'setosa')
ddata(~Species, 'setosa', data=iris)
}
\keyword{distribution}

