% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pqrdata.R
\name{qdata_v}
\alias{cdata_f}
\alias{cdata_v}
\alias{ddata_f}
\alias{ddata_v}
\alias{pdata_f}
\alias{pdata_v}
\alias{qdata_f}
\alias{qdata_v}
\alias{rdata_f}
\alias{rdata_v}
\title{The Data Distribution}
\usage{
qdata_v(x, p = seq(0, 1, 0.25), na.rm = TRUE, ...)

qdata_f(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))

cdata_v(x, p = 0.95, na.rm = TRUE, ...)

cdata_f(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))

pdata_v(x, q, lower.tail = TRUE, ...)

pdata_f(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))

rdata_v(vals, n, replace = TRUE, ...)

rdata_f(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))

ddata_v(vals, q, ..., data = NULL, log = FALSE, na.rm = TRUE)

ddata_f(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))
}
\arguments{
\item{x}{an object}

\item{p}{a vector of probabilities}

\item{na.rm}{a logical indicating whether \code{NA}s should be removed before computing.}

\item{data}{a data frame in which to evaluate vals}

\item{groups}{a grouping variable, typically the name of a variable in \code{data}}

\item{q}{a vector of quantiles}

\item{lower.tail}{a logical indicating whether to use the lower or upper tail probability}

\item{vals}{a vector containing the data}

\item{n}{number of values to sample}

\item{replace}{a logical indicating whether to sample with replacement}

\item{log}{a logical indicating whether the result should be log transformed}

\item{\dots}{additional arguments passed to \code{quantile} or \code{sample}}
}
\description{
Utility functions for density, distribution function, quantile function,
and random generation from data.
}
\seealso{
\code{\link{ddata}}, \code{\link{pdata}}, \code{\link{qdata}},
\code{\link{rdata}}, \code{\link{cdata}}
}

