% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomat.R
\name{biomat}
\alias{biomat}
\title{Matrix with variables for modelling}
\usage{
biomat(data, varstack)
}
\arguments{
\item{data}{Data frame with coordinates in the first two columns and presence/absence 
(1=presence, 0=absence) in the third column.}

\item{varstack}{RasterStack of the variables from which values are extracted for each point in
\code{data}.}
}
\value{
2D matrix with the dependent variable (presence/absence) in the first column
and the independent variables (extracted from varstack) in the rest.
}
\description{
Prepares matrix with variables for modeling
}
\examples{
## Load climate data
destfile <- tempfile()
data.url <- "https://raw.githubusercontent.com/SantanderMetGroup/mopa/master/data/biostack.rda"
download.file(data.url, destfile)
load(destfile, verbose = TRUE)

## Load and prepare presence data
data(Oak_phylo2)
dfp <-cbind(Oak_phylo2[[1]], "pa"= rep(1,nrow(Oak_phylo2[[1]])))
dfa <-cbind(Oak_phylo2[[2]], "pa"= rep(0,nrow(Oak_phylo2[[2]])))
df3 <-rbind(dfp, dfa)

## Build the data matrix for modeling
mat <-biomat(df3, biostack$baseline)
str(mat)

}
\author{
M. Iturbide
}
\keyword{internal}
