% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backgroundRadius.R
\name{backgroundRadius}
\alias{backgroundRadius}
\title{Background extent restriction for a sequence of distances}
\usage{
backgroundRadius(xy, background, start = 0.166, by = 0.083,
  unit = c("decimal degrees", "utm"))
}
\arguments{
\item{xy}{Data frame or list of data frames with coordinates (each row is a point) 
---typically species presence data--- to be considered as starting points from which different 
background extents are created.}

\item{background}{Matrix or list of matrices of background coordinates.
Object derived from function \code{\link[mopa]{OCSVMprofiling}} (component \code{$absence}). 
Alternatively, object derived from function \code{\link[mopa]{backgroundGrid}} (component \code{$xy}) 
if the environmental profiling step is going to be avoided in the pseudo-absence 
generation proccess).}

\item{start}{Value for the minimum distance to consider for extent limitations. 
Default is 0.166}

\item{by}{Value of the distance to consider from one extent to the following. 
Default is 0.083}

\item{unit}{Character indicating the coordinate system of the objects. 
Default is \code{"decimal degrees"}, alternatively \code{"utm"} can be used}
}
\value{
List/s of matrixes with xy coordinates, each matrix correspond to a different 
background extent.
}
\description{
Creation of point-grid backgrounds through the establishment of extent 
limitations for a sequence of distances, from near presence locations to the length 
of the half diagonal of the bounding that encloses the background (study area).
}
\details{
Argument unit is only used to set extent distances in km. This function is aimed at 
creating backgrounds of different extent for pseudo-absence samplig based on an initial 
point grid (derived from function \code{\link[mopa]{OCSVMprofiling}} or function 
\code{\link[mopa]{backgroundGrid}}). If this function is used for a subsequent application of
functions \code{\link[mopa]{pseudoAbsences}} and \code{\link[mopa]{mopaTrain}}, the last will perform species distribution
modeling for each of the extents here established, and will return the fitted model that belongs to 
the optimum background extent (see references).
}
\examples{

## Considering a single group of presence points
data(Q_pubescens)
presences <- Q_pubescens[sample(1:300, size = 100),]

# Define the spatial characteristics of the study area
r <- raster(nrows=50, ncols=50, xmn=-10, xmx=20, ymn=35, ymx=65, vals = rep(1, 50*50))

# Background of the whole study area
bg <- backgroundGrid(r)

# Partition of the study area
bg.extents <- backgroundRadius(xy = presences, background = bg$xy, 
                            start = 0.166, by = 0.083*50, unit = "decimal degrees")


\donttest{
## Considering more than one groups of presence points
data(Oak_phylo2)

# Obtaining the raster that defines the spatial characteristics of the study area
destfile <- tempfile()
data.url <- "https://raw.githubusercontent.com/SantanderMetGroup/mopa/master/data/biostack.rda"
download.file(data.url, destfile)
load(destfile, verbose = TRUE)

projection(biostack$baseline) <- CRS("+proj=longlat +init=epsg:4326")
r <- biostack$baseline[[1]]
# Background of the whole study area
bg <- backgroundGrid(r)

# Partition of the study area
bg.extents <- backgroundRadius(xy = Oak_phylo2, background = bg$xy, 
start = 0.166, by = 0.083*10, unit = "decimal degrees")
}

}
\references{
Iturbide, M., Bedia, J., Herrera, S., del Hierro, O., Pinto, M., Gutierrez, J.M., 2015. 
A framework for species distribution modelling with improved pseudo-absence generation. Ecological 
Modelling. DOI:10.1016/j.ecolmodel.2015.05.018.
}
\seealso{
\code{\link[mopa]{mopaTrain}}, \code{\link[mopa]{pseudoAbsences}}, \code{\link[mopa]{backgroundGrid}}, 
\code{\link[mopa]{OCSVMprofiling}}
}
\author{
M. Iturbide
}
