% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{phosphoprotein_data}
\alias{phosphoprotein_data}
\title{Phosphosite data}
\format{
\describe{
  \item{group1}{ER+ data}
  \describe{
    \item{data}{raw data, phosphosites in columns and samples in rows}
    \item{identifiers}{one column per identifier, rows in the same order as the phoshosite order
    in 'data', identifiers: Phosphosite ID, RefSeq ID, gene name}
    }
  \item{group2}{ER- data}
  \describe{
    \item{data}{see above}
    \item{identifiers}{see above}
    }
}
}
\source{
Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis and Targeted
 Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036
}
\usage{
phosphoprotein_data
}
\description{
Phosphosite analysis of breast cancer patients data from Krug et al., 2020 (data from the
Clinical Proteomic Tumor Analysis Consortium (CPTAC)). The data is stratified by estrogen
receptor (ER) expression status (group1 = ER+, group2 = ER-). Each group is given as a sub-list
containing 'data' (raw data, phosphosites in columns and samples in rows) and 'identifiers'
(one column per identifier, rows in the same order as the phosphosite order in 'data').
}
\keyword{datasets}
