% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candles.R
\name{get_candles}
\alias{get_candles}
\title{Get Candles for a Set of Securities}
\usage{
get_candles(secid, from, till = NULL, interval = "monthly", ...)
}
\arguments{
\item{secid}{A vector of security ID's.}

\item{from}{A \link[lubridate:date]{lubridate::date} object or a character that can be coerced to
it.}

\item{till}{A \link[lubridate:date]{lubridate::date} object or a character that can be coerced to
it.}

\item{interval}{A character value specifying the candle duration (see
\code{moexer.candle.intervals} option.)}

\item{...}{Further arguments to \link{query_iss}.}
}
\value{
A tibble as with candles in HLOCV format, plus a column with the
corresponding security ID.
}
\description{
REST path:
\verb{/engines/[engine]/markets/[market]/boards/[board]/securities/[security]/candles}
(see \url{http://iss.moex.com/iss/reference/46}).
}
\details{
To get the \code{engine-market-board} path a separate \link{get_security_info} query is
made and the board with \code{is_primary = 1} is selected.
}
\examples{
\dontrun{
get_candles(
    secid = c('XXXX', 'SBER', 'FXGD'),
    from = '2020-01-01',
    debug = TRUE
)
}
}
