% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candles.R
\name{get_candle_borders}
\alias{get_candle_borders}
\title{Get Possible Candle \code{from-till} Values for a Security}
\usage{
get_candle_borders(secid, ...)
}
\arguments{
\item{secid}{A vector of security ID's.}

\item{...}{Further arguments to \link{query_iss}.}
}
\value{
A tibble with possible \code{from-till} values for each interval;
additionally the intervals-durations mapping tibble is joined.
}
\description{
REST path:
\verb{/engines/[engine]/markets/[market]/boards/[board]/securities/[security]/candleborders}
(see \url{http://iss.moex.com/iss/reference/48}).
}
\details{
To get the \code{engine-market-board} path a separate \link{get_security_info} query is
made and the board with \code{is_primary = 1} is selected.
}
\examples{
\dontrun{
get_candle_borders(secid = c('SBER', 'FXGD'))
}
}
