% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moderate.mediation.R
\name{summary_modmed}
\alias{summary_modmed}
\title{Summarizing Output for Causal Moderated Mediation Analysis
'summary_modmed' is used to report from causal moderated mediation analysis}
\usage{
summary_modmed(object)
}
\arguments{
\item{object}{output from \code{modmed} function}
}
\value{
\code{modmed} returns causal moderated mediation analysis results. The \code{summary_modmed} function provides summary tables of the results.
}
\description{
Summarizing Output for Causal Moderated Mediation Analysis
'summary_modmed' is used to report from causal moderated mediation analysis
}
\examples{
\donttest{
data(newws)
modmed.results = modmed(data = newws, treatment = "treat", mediator = "emp",
    outcome = "depression", covariates.disc = c("emp_prior", "nevmar",
        "hispanic", "nohsdip"), covariates.cont = c("workpref", "attitude",
        "depress_prior"), moderators.disc = "CHCNT", moderators.cont = "ADCPC",
    m.model = list(intercept = c("ADCPC", "CHCNT"), treatment = c("ADCPC",
        "CHCNT"), emp_prior = NULL, nevmar = NULL, hispanic = NULL,
        nohsdip = NULL, workpref = NULL, attitude = NULL, depress_prior = NULL),
    y.model = list(intercept = c("ADCPC", "CHCNT"), treatment = c("ADCPC",
        "CHCNT"), mediator = c("ADCPC", "CHCNT"), tm = c("ADCPC",
        "CHCNT"), emp_prior = NULL, nevmar = NULL, hispanic = NULL,
        nohsdip = NULL, workpref = NULL, attitude = NULL, depress_prior = NULL),
    comp.mod.disc.values = 3, ref.mod.disc.values = 2, comp.mod.cont.values = 5050,
    ref.mod.cont.values = 5050, m.scale = "binary", y.scale = "continuous",
    seed = 1)
summary_modmed(modmed.results)
}
}
\references{
Qin, X., & Wang, L. (2022). Causal Moderated Mediation Analysis.
}
\author{
Xu Qin and Lijuan Wang
}
