% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-arima_boost.R
\name{arima_xgboost_fit_impl}
\alias{arima_xgboost_fit_impl}
\title{Bridge ARIMA-XGBoost Modeling function}
\usage{
arima_xgboost_fit_impl(
  x,
  y,
  period = "auto",
  p = 0,
  d = 0,
  q = 0,
  P = 0,
  D = 0,
  Q = 0,
  include.mean = TRUE,
  include.drift = FALSE,
  include.constant,
  lambda = model$lambda,
  biasadj = FALSE,
  method = c("CSS-ML", "ML", "CSS"),
  model = NULL,
  max_depth = 6,
  nrounds = 15,
  eta = 0.3,
  colsample_bytree = NULL,
  colsample_bynode = NULL,
  min_child_weight = 1,
  gamma = 0,
  subsample = 1,
  validation = 0,
  early_stop = NULL,
  ...
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{period}{A seasonal frequency. Uses "auto" by default. A character phrase
of "auto" or time-based phrase of "2 weeks" can be used if a date or date-time variable is provided.}

\item{p}{The order of the non-seasonal auto-regressive (AR) terms.}

\item{d}{The order of integration for non-seasonal differencing.}

\item{q}{The order of the non-seasonal moving average (MA) terms.}

\item{P}{The order of the seasonal auto-regressive (SAR) terms.}

\item{D}{The order of integration for seasonal differencing.}

\item{Q}{The order of the seasonal moving average (SMA) terms.}

\item{include.mean}{Should the ARIMA model include a mean term? The default
is \code{TRUE} for undifferenced series, \code{FALSE} for differenced ones
(where a mean would not affect the fit nor predictions).}

\item{include.drift}{Should the ARIMA model include a linear drift term?
(i.e., a linear regression with ARIMA errors is fitted.)  The default is
\code{FALSE}.}

\item{include.constant}{If \code{TRUE}, then \code{include.mean} is set to
be \code{TRUE} for undifferenced series and \code{include.drift} is set to
be \code{TRUE} for differenced series. Note that if there is more than one
difference taken, no constant is included regardless of the value of this
argument. This is deliberate as otherwise quadratic and higher order
polynomial trends would be induced.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda="auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted values,
a regular back transformation will result in median forecasts. If biasadj is TRUE,
an adjustment will be made to produce mean forecasts and fitted values.}

\item{method}{Fitting method: maximum likelihood or minimize conditional
sum-of-squares. The default (unless there are missing values) is to use
conditional-sum-of-squares to find starting values, then maximum likelihood.}

\item{model}{Output from a previous call to \code{Arima}. If model is
passed, this same model is fitted to \code{y} without re-estimating any
parameters.}

\item{max_depth}{An integer for the maximum depth of the tree.}

\item{nrounds}{An integer for the number of boosting iterations.}

\item{eta}{A numeric value between zero and one to control the learning rate.}

\item{colsample_bytree}{Subsampling proportion of columns.}

\item{colsample_bynode}{Subsampling proportion of columns for each node
within each tree. See the \code{counts} argument below. The default uses all
columns.}

\item{min_child_weight}{A numeric value for the minimum sum of instance
weights needed in a child to continue to split.}

\item{gamma}{A number for the minimum loss reduction required to make a
further partition on a leaf node of the tree}

\item{subsample}{Subsampling proportion of rows.}

\item{validation}{A positive number. If on \verb{[0, 1)} the value, \code{validation}
is a random proportion of data in \code{x} and \code{y} that are used for performance
assessment and potential early stopping. If 1 or greater, it is the \emph{number}
of training set samples use for these purposes.}

\item{early_stop}{An integer or \code{NULL}. If not \code{NULL}, it is the number of
training iterations without improvement before stopping. If \code{validation} is
used, performance is base on the validation set; otherwise the training set
is used.}

\item{...}{Additional arguments passed to \code{xgboost::xgb.train}}
}
\description{
Bridge ARIMA-XGBoost Modeling function
}
\keyword{internal}
