% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{smallpox_19581973_Europe}
\alias{smallpox_19581973_Europe}
\title{A dataset of smallpox outbreaks in Europe}
\format{
A data frame (\code{data.frame}) with 34 of records, and 3 columns of variables:
\describe{
\item{\code{obs.seed}}{Observations of the number of seed cases that generated the offspring cases in the next transmission generation.}
\item{\code{obs.clustersize}}{Observations of next-generation cluster size generated by given numbers (given in \code{obs.seed}) of seed cases.}
\item{\code{type.obs}}{A categorical variable takes the value "nextgen_clustersize" indicating the type of observations.}
}
}
\usage{
smallpox_19581973_Europe
}
\description{
This dataset (i.e., \code{smallpox_19581973_Europe}) contains 34 observations of \strong{next-generation cluster size} generated by given numbers of seed cases,
which were collected in smallpox outbreaks in Europe from 1958 to 1973.
Here, in this dataset, only the smallpox case observations involved in the \emph{first} indigenous transmission generation were recorded.
}
\examples{
data(smallpox_19581973_Europe)
summary(smallpox_19581973_Europe)

}
\references{
Fenner F, Henderson DA, Arita I, Jezek Z, Ladnyi ID. Smallpox and its eradication. \emph{Geneva: World Health Organization}. 1988.
\url{https://apps.who.int/iris/handle/10665/39485}, see Table 23.4 for the raw data.

Blumberg S, Funk S, Pulliam JR. Detecting differential transmissibilities that affect the size of self-limited outbreaks. \emph{PLoS Pathogens}. 2014;10(10):e1004452.
\doi{10.1371/journal.ppat.1004452}, see Table 3 in the data supplementary file for the processed data.
}
\keyword{datasets}
